/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.fluentd.ingester.sender.NetworkSender;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.validation.Validatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPSender
extends NetworkSender<SocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(TCPSender.class);
    private final AtomicReference<SocketChannel> channel = new AtomicReference();
    private final Config config;

    public TCPSender() {
        this(new Config());
    }

    public TCPSender(Config config) {
        this(config, null);
    }

    public TCPSender(FailureDetector failureDetector) {
        this(new Config(), failureDetector);
    }

    public TCPSender(Config config, FailureDetector failureDetector) {
        super(config, failureDetector);
        config.validateValues();
        this.config = config;
    }

    @Override
    protected SocketChannel getOrCreateSocketInternal() throws IOException {
        if (this.channel.get() == null) {
            SocketChannel socketChannel = SocketChannel.open();
            try {
                socketChannel.socket().connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), this.config.getConnectionTimeoutMilli());
                socketChannel.socket().setTcpNoDelay(true);
                socketChannel.socket().setSoTimeout(this.config.getReadTimeoutMilli());
            }
            catch (Throwable e) {
                socketChannel.close();
                throw e;
            }
            this.channel.set(socketChannel);
        }
        return this.channel.get();
    }

    @Override
    protected void sendBuffers(SocketChannel socketChannel, List<ByteBuffer> buffers) throws IOException {
        socketChannel.write(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    @Override
    protected void recvResponse(SocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        socketChannel.read(buffer);
    }

    @Override
    protected void closeSocket() throws IOException {
        SocketChannel existingSocketChannel = this.channel.getAndSet(null);
        if (existingSocketChannel != null) {
            existingSocketChannel.close();
        }
    }

    @Override
    public String toString() {
        return "TCPSender{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    extends NetworkSender.Config
    implements Validatable {
        void validateValues() {
            this.validate();
        }
    }
}

