/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.heartbeat;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.komamitsu.fluency.fluentd.ingester.sender.heartbeat.Heartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPHeartbeater
extends Heartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(UDPHeartbeater.class);
    private final SocketAddress socketAddress;

    public UDPHeartbeater() {
        this(new Config());
    }

    public UDPHeartbeater(Config config) {
        super(config);
        this.socketAddress = new InetSocketAddress(config.getHost(), config.getPort());
    }

    @Override
    protected void invoke() throws IOException {
        try (DatagramChannel datagramChannel = DatagramChannel.open();){
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            datagramChannel.send(byteBuffer, this.socketAddress);
            datagramChannel.receive(byteBuffer);
            this.pong();
        }
    }

    @Override
    public String toString() {
        return "UDPHeartbeater{socketAddress=" + this.socketAddress + "} " + super.toString();
    }

    public static class Config
    extends Heartbeater.Config {
    }
}

