/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocket;
import org.komamitsu.fluency.fluentd.ingester.sender.NetworkSender;
import org.komamitsu.fluency.fluentd.ingester.sender.SSLSocketBuilder;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.validation.Validatable;

public class SSLSender
extends NetworkSender<SSLSocket> {
    private final AtomicReference<SSLSocket> socket = new AtomicReference();
    private final SSLSocketBuilder socketBuilder;
    private final Config config;

    public SSLSender() {
        this(new Config());
    }

    public SSLSender(Config config) {
        this(config, null);
    }

    public SSLSender(FailureDetector failureDetector) {
        this(new Config(), failureDetector);
    }

    public SSLSender(Config config, FailureDetector failureDetector) {
        super(config, failureDetector);
        config.validateValues();
        this.socketBuilder = new SSLSocketBuilder(config.getHost(), config.getPort(), config.getConnectionTimeoutMilli(), config.getReadTimeoutMilli());
        this.config = config;
    }

    @Override
    protected SSLSocket getOrCreateSocketInternal() throws IOException {
        if (this.socket.get() == null) {
            this.socket.set(this.socketBuilder.build());
        }
        return this.socket.get();
    }

    @Override
    protected void sendBuffers(SSLSocket sslSocket, List<ByteBuffer> buffers) throws IOException {
        for (ByteBuffer buffer : buffers) {
            OutputStream outputStream = sslSocket.getOutputStream();
            if (buffer.isDirect()) {
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                outputStream.write(bytes);
                continue;
            }
            outputStream.write(buffer.array());
        }
    }

    @Override
    protected void recvResponse(SSLSocket sslSocket, ByteBuffer buffer) throws IOException {
        InputStream inputStream = sslSocket.getInputStream();
        byte[] tempBuf = new byte[buffer.remaining()];
        int read = inputStream.read(tempBuf);
        buffer.put(tempBuf, 0, read);
    }

    @Override
    protected void closeSocket() throws IOException {
        SSLSocket existingSocket = this.socket.getAndSet(null);
        if (existingSocket != null) {
            existingSocket.close();
        }
    }

    @Override
    public String toString() {
        return "SSLSender{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    extends NetworkSender.Config
    implements Validatable {
        void validateValues() {
            this.validate();
        }
    }
}

