/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.komamitsu.fluency.fluentd.ingester.sender.FluentdSender;
import org.komamitsu.fluency.fluentd.ingester.sender.RequestOption;
import org.komamitsu.fluency.ingester.Ingester;
import org.komamitsu.fluency.ingester.sender.Sender;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentdIngester
implements Ingester {
    private static final Logger LOG = LoggerFactory.getLogger(FluentdIngester.class);
    private static final Charset CHARSET = Charset.forName("ASCII");
    private final Config config;
    private final FluentdSender sender;
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    public FluentdIngester(FluentdSender sender) {
        this(new Config(), sender);
    }

    public FluentdIngester(Config config, FluentdSender sender) {
        this.config = config;
        this.sender = sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ingest(String tag, ByteBuffer dataBuffer) throws IOException {
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        MessagePacker messagePacker = MessagePack.newDefaultPacker((OutputStream)header);
        int dataLength = dataBuffer.limit();
        messagePacker.packArrayHeader(3);
        messagePacker.packString(tag);
        messagePacker.packRawStringHeader(dataLength);
        messagePacker.flush();
        ByteBuffer headerBuffer = ByteBuffer.wrap(header.toByteArray());
        if (this.config.isAckResponseMode()) {
            byte[] uuidBytes = UUID.randomUUID().toString().getBytes(CHARSET);
            ByteBuffer optionBuffer = ByteBuffer.wrap(this.objectMapper.writeValueAsBytes((Object)new RequestOption(dataLength, uuidBytes)));
            List<ByteBuffer> buffers = Arrays.asList(headerBuffer, dataBuffer, optionBuffer);
            FluentdSender fluentdSender = this.sender;
            synchronized (fluentdSender) {
                this.sender.sendWithAck(buffers, uuidBytes);
            }
        }
        ByteBuffer optionBuffer = ByteBuffer.wrap(this.objectMapper.writeValueAsBytes((Object)new RequestOption(dataLength, null)));
        List<ByteBuffer> buffers = Arrays.asList(headerBuffer, dataBuffer, optionBuffer);
        LOG.debug("calling sender.send with buffers {}", buffers);
        FluentdSender fluentdSender = this.sender;
        synchronized (fluentdSender) {
            this.sender.send(buffers);
        }
    }

    @Override
    public Sender getSender() {
        return this.sender;
    }

    public boolean isAckResponseMode() {
        return this.config.isAckResponseMode();
    }

    @Override
    public void close() throws IOException {
        this.sender.close();
    }

    public static class Config {
        private boolean ackResponseMode = false;

        public boolean isAckResponseMode() {
            return this.ackResponseMode;
        }

        public void setAckResponseMode(boolean ackResponseMode) {
            this.ackResponseMode = ackResponseMode;
        }
    }
}

