/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.FluencyBuilder;
import org.komamitsu.fluency.fluentd.ingester.FluentdIngester;
import org.komamitsu.fluency.fluentd.ingester.sender.FluentdSender;
import org.komamitsu.fluency.fluentd.ingester.sender.MultiSender;
import org.komamitsu.fluency.fluentd.ingester.sender.RetryableSender;
import org.komamitsu.fluency.fluentd.ingester.sender.SSLSender;
import org.komamitsu.fluency.fluentd.ingester.sender.TCPSender;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.PhiAccrualFailureDetectStrategy;
import org.komamitsu.fluency.fluentd.ingester.sender.heartbeat.SSLHeartbeater;
import org.komamitsu.fluency.fluentd.ingester.sender.heartbeat.TCPHeartbeater;
import org.komamitsu.fluency.fluentd.ingester.sender.retry.ExponentialBackOffRetryStrategy;
import org.komamitsu.fluency.fluentd.recordformat.FluentdRecordFormatter;
import org.komamitsu.fluency.ingester.Ingester;
import org.komamitsu.fluency.recordformat.RecordFormatter;

public class FluencyBuilderForFluentd
extends FluencyBuilder {
    private Integer senderMaxRetryCount;
    private boolean ackResponseMode;
    private boolean sslEnabled;
    private Integer connectionTimeoutMilli;
    private Integer readTimeoutMilli;

    public Integer getSenderMaxRetryCount() {
        return this.senderMaxRetryCount;
    }

    public void setSenderMaxRetryCount(Integer senderMaxRetryCount) {
        this.senderMaxRetryCount = senderMaxRetryCount;
    }

    public boolean isAckResponseMode() {
        return this.ackResponseMode;
    }

    public void setAckResponseMode(boolean ackResponseMode) {
        this.ackResponseMode = ackResponseMode;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Integer getConnectionTimeoutMilli() {
        return this.connectionTimeoutMilli;
    }

    public void setConnectionTimeoutMilli(Integer connectionTimeoutMilli) {
        this.connectionTimeoutMilli = connectionTimeoutMilli;
    }

    public Integer getReadTimeoutMilli() {
        return this.readTimeoutMilli;
    }

    public void setReadTimeoutMilli(Integer readTimeoutMilli) {
        this.readTimeoutMilli = readTimeoutMilli;
    }

    public Fluency build(String host, int port) {
        return this.buildFromIngester(this.buildRecordFormatter(), this.buildIngester(this.createBaseSender(host, port)));
    }

    public Fluency build(int port) {
        return this.buildFromIngester(this.buildRecordFormatter(), this.buildIngester(this.createBaseSender(null, port)));
    }

    public Fluency build() {
        return this.buildFromIngester(this.buildRecordFormatter(), this.buildIngester(this.createBaseSender(null, null)));
    }

    public Fluency build(List<InetSocketAddress> servers) {
        ArrayList<FluentdSender> senders = new ArrayList<FluentdSender>();
        for (InetSocketAddress server : servers) {
            senders.add(this.createBaseSender(server.getHostName(), server.getPort(), true));
        }
        return this.buildFromIngester(this.buildRecordFormatter(), this.buildIngester(new MultiSender(senders)));
    }

    private FluentdSender createBaseSender(String host, Integer port) {
        return this.createBaseSender(host, port, false);
    }

    private FluentdSender createBaseSender(String host, Integer port, boolean withHeartBeater) {
        if (withHeartBeater && port == null) {
            throw new IllegalArgumentException("`port` should be specified when using heartbeat");
        }
        if (this.isSslEnabled()) {
            SSLSender.Config senderConfig = new SSLSender.Config();
            FailureDetector failureDetector = null;
            if (host != null) {
                senderConfig.setHost(host);
            }
            if (port != null) {
                senderConfig.setPort(port);
            }
            if (withHeartBeater) {
                SSLHeartbeater.Config hbConfig = new SSLHeartbeater.Config();
                hbConfig.setHost(host);
                hbConfig.setPort(port);
                SSLHeartbeater heartbeater = new SSLHeartbeater(hbConfig);
                failureDetector = new FailureDetector(new PhiAccrualFailureDetectStrategy(), heartbeater);
            }
            if (this.connectionTimeoutMilli != null) {
                senderConfig.setConnectionTimeoutMilli(this.connectionTimeoutMilli);
            }
            if (this.readTimeoutMilli != null) {
                senderConfig.setReadTimeoutMilli(this.readTimeoutMilli);
            }
            return new SSLSender(senderConfig, failureDetector);
        }
        TCPSender.Config senderConfig = new TCPSender.Config();
        FailureDetector failureDetector = null;
        if (host != null) {
            senderConfig.setHost(host);
        }
        if (port != null) {
            senderConfig.setPort(port);
        }
        if (withHeartBeater) {
            TCPHeartbeater.Config hbConfig = new TCPHeartbeater.Config();
            hbConfig.setHost(host);
            hbConfig.setPort(port);
            TCPHeartbeater heartbeater = new TCPHeartbeater(hbConfig);
            failureDetector = new FailureDetector(new PhiAccrualFailureDetectStrategy(), heartbeater);
        }
        if (this.connectionTimeoutMilli != null) {
            senderConfig.setConnectionTimeoutMilli(this.connectionTimeoutMilli);
        }
        if (this.readTimeoutMilli != null) {
            senderConfig.setReadTimeoutMilli(this.readTimeoutMilli);
        }
        return new TCPSender(senderConfig, failureDetector);
    }

    @Override
    public String toString() {
        return "FluencyBuilder{senderMaxRetryCount=" + this.senderMaxRetryCount + ", ackResponseMode=" + this.ackResponseMode + ", sslEnabled=" + this.sslEnabled + "} " + super.toString();
    }

    private RecordFormatter buildRecordFormatter() {
        return new FluentdRecordFormatter();
    }

    private Ingester buildIngester(FluentdSender baseSender) {
        ExponentialBackOffRetryStrategy.Config retryStrategyConfig = new ExponentialBackOffRetryStrategy.Config();
        if (this.getSenderMaxRetryCount() != null) {
            retryStrategyConfig.setMaxRetryCount(this.getSenderMaxRetryCount());
        }
        if (this.getSenderMaxRetryCount() != null) {
            retryStrategyConfig.setMaxRetryCount(this.getSenderMaxRetryCount());
        }
        RetryableSender.Config senderConfig = new RetryableSender.Config();
        if (this.getErrorHandler() != null) {
            senderConfig.setErrorHandler(this.getErrorHandler());
        }
        RetryableSender retryableSender = new RetryableSender(senderConfig, baseSender, new ExponentialBackOffRetryStrategy(retryStrategyConfig));
        FluentdIngester.Config ingesterConfig = new FluentdIngester.Config();
        ingesterConfig.setAckResponseMode(this.isAckResponseMode());
        return new FluentdIngester(ingesterConfig, retryableSender);
    }
}

