/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency;

import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.ingester.Ingester;
import org.komamitsu.fluency.ingester.sender.ErrorHandler;
import org.komamitsu.fluency.recordformat.RecordFormatter;
import org.msgpack.core.annotations.VisibleForTesting;

public class FluencyBuilder {
    private Long maxBufferSize;
    private Integer bufferChunkInitialSize;
    private Integer bufferChunkRetentionSize;
    private Integer bufferChunkRetentionTimeMillis;
    private Integer flushIntervalMillis;
    private String fileBackupDir;
    private Integer waitUntilBufferFlushed;
    private Integer waitUntilFlusherTerminated;
    private Boolean jvmHeapBufferMode;
    private ErrorHandler errorHandler;

    public Long getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(Long maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public Integer getBufferChunkInitialSize() {
        return this.bufferChunkInitialSize;
    }

    public void setBufferChunkInitialSize(Integer bufferChunkInitialSize) {
        this.bufferChunkInitialSize = bufferChunkInitialSize;
    }

    public Integer getBufferChunkRetentionSize() {
        return this.bufferChunkRetentionSize;
    }

    public void setBufferChunkRetentionSize(Integer bufferChunkRetentionSize) {
        this.bufferChunkRetentionSize = bufferChunkRetentionSize;
    }

    public Integer getBufferChunkRetentionTimeMillis() {
        return this.bufferChunkRetentionTimeMillis;
    }

    public void setBufferChunkRetentionTimeMillis(Integer bufferChunkRetentionTimeMillis) {
        this.bufferChunkRetentionTimeMillis = bufferChunkRetentionTimeMillis;
    }

    public Integer getFlushIntervalMillis() {
        return this.flushIntervalMillis;
    }

    public void setFlushIntervalMillis(Integer flushIntervalMillis) {
        this.flushIntervalMillis = flushIntervalMillis;
    }

    public String getFileBackupDir() {
        return this.fileBackupDir;
    }

    public void setFileBackupDir(String fileBackupDir) {
        this.fileBackupDir = fileBackupDir;
    }

    public Integer getWaitUntilBufferFlushed() {
        return this.waitUntilBufferFlushed;
    }

    public void setWaitUntilBufferFlushed(Integer waitUntilBufferFlushed) {
        this.waitUntilBufferFlushed = waitUntilBufferFlushed;
    }

    public Integer getWaitUntilFlusherTerminated() {
        return this.waitUntilFlusherTerminated;
    }

    public void setWaitUntilFlusherTerminated(Integer waitUntilFlusherTerminated) {
        this.waitUntilFlusherTerminated = waitUntilFlusherTerminated;
    }

    public Boolean getJvmHeapBufferMode() {
        return this.jvmHeapBufferMode;
    }

    public void setJvmHeapBufferMode(Boolean jvmHeapBufferMode) {
        this.jvmHeapBufferMode = jvmHeapBufferMode;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String toString() {
        return "BaseFluencyBuilder{maxBufferSize=" + this.maxBufferSize + ", bufferChunkInitialSize=" + this.bufferChunkInitialSize + ", bufferChunkRetentionSize=" + this.bufferChunkRetentionSize + ", bufferChunkRetentionTimeMillis=" + this.bufferChunkRetentionTimeMillis + ", flushIntervalMillis=" + this.flushIntervalMillis + ", fileBackupDir='" + this.fileBackupDir + '\'' + ", waitUntilBufferFlushed=" + this.waitUntilBufferFlushed + ", waitUntilFlusherTerminated=" + this.waitUntilFlusherTerminated + ", jvmHeapBufferMode=" + this.jvmHeapBufferMode + ", errorHandler=" + this.errorHandler + '}';
    }

    @VisibleForTesting
    public Fluency createFluency(RecordFormatter recordFormatter, Ingester ingester, Buffer.Config bufferConfig, Flusher.Config flusherConfig) {
        Buffer buffer = new Buffer(bufferConfig, recordFormatter);
        Flusher flusher = new Flusher(flusherConfig, buffer, ingester);
        return new Fluency(buffer, flusher);
    }

    public Fluency buildFromIngester(RecordFormatter recordFormatter, Ingester ingester) {
        Buffer.Config bufferConfig = new Buffer.Config();
        this.configureBufferConfig(bufferConfig);
        Flusher.Config flusherConfig = new Flusher.Config();
        this.configureFlusherConfig(flusherConfig);
        return this.createFluency(recordFormatter, ingester, bufferConfig, flusherConfig);
    }

    private void configureBufferConfig(Buffer.Config bufferConfig) {
        if (this.getMaxBufferSize() != null) {
            bufferConfig.setMaxBufferSize(this.getMaxBufferSize());
        }
        if (this.getBufferChunkInitialSize() != null) {
            bufferConfig.setChunkInitialSize(this.getBufferChunkInitialSize());
        }
        if (this.getBufferChunkRetentionSize() != null) {
            bufferConfig.setChunkRetentionSize(this.getBufferChunkRetentionSize());
        }
        if (this.getBufferChunkRetentionTimeMillis() != null) {
            bufferConfig.setChunkRetentionTimeMillis(this.getBufferChunkRetentionTimeMillis());
        }
        if (this.getFileBackupDir() != null) {
            bufferConfig.setFileBackupDir(this.getFileBackupDir());
        }
        if (this.getJvmHeapBufferMode() != null) {
            bufferConfig.setJvmHeapBufferMode(this.getJvmHeapBufferMode());
        }
    }

    protected void configureFlusherConfig(Flusher.Config flusherConfig) {
        if (this.getFlushIntervalMillis() != null) {
            flusherConfig.setFlushIntervalMillis(this.getFlushIntervalMillis());
        }
        if (this.getWaitUntilBufferFlushed() != null) {
            flusherConfig.setWaitUntilBufferFlushed(this.getWaitUntilBufferFlushed());
        }
        if (this.getWaitUntilFlusherTerminated() != null) {
            flusherConfig.setWaitUntilTerminated(this.getWaitUntilFlusherTerminated());
        }
    }
}

