/*
 * Decompiled with CFR 0.152.
 */
package io.monalabs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.sender.SenderErrorHandler;

public class MonaClient
implements Closeable {
    private static final String MONA_ARC_CLASS_FIELD_NAME = "MONA_ARC_CLASS";
    private static final Logger LOGGER = Logger.getLogger(MonaClient.class.getName());
    private final Fluency fluency;
    private final String monaUserId;

    protected MonaClient(Fluency fluency, String monaUserId) {
        this.fluency = fluency;
        this.monaUserId = monaUserId;
    }

    private MonaClient(Builder builder) {
        this(Fluency.defaultFluency((String)builder.host, (int)builder.port, (Fluency.Config)new Fluency.Config().setBufferChunkInitialSize(Integer.valueOf(builder.bufferChunkInitialSize)).setBufferChunkRetentionSize(Integer.valueOf(builder.bufferChunkRetentionSize)).setMaxBufferSize(Long.valueOf(builder.maxBufferSize)).setFlushIntervalMillis(Integer.valueOf(builder.flushIntervalMillis)).setSslEnabled(true).setSenderErrorHandler(new SenderErrorHandler(){

            public void handle(Throwable e) {
                LOGGER.warning(String.format("Error sending data to Mona: %s", e.getMessage()));
            }
        })), builder.monaUserId);
    }

    @Override
    public void close() {
        try {
            this.fluency.close();
        }
        catch (Exception e) {
            LOGGER.warning(String.format("IO Exception when closing link to fluentd: %s", e.getMessage()));
        }
    }

    private int amountOfDotsInString(String checkedString) {
        return checkedString.length() - checkedString.replace(".", "").length();
    }

    public void exportStandalone(String arcClass, String contextId, Map<String, Object> message) {
        int missingContextIdsCount;
        if (message == null) {
            LOGGER.warning("Tried to export null message");
            return;
        }
        if (message.isEmpty()) {
            LOGGER.warning("Tried to export empty message");
            return;
        }
        if (arcClass == null || arcClass.isEmpty()) {
            LOGGER.warning("Tried to export with empty ARC class");
            return;
        }
        if (arcClass.endsWith(".")) {
            LOGGER.warning("ARC classes cannot end with dots");
            return;
        }
        if (contextId == null) {
            contextId = "";
        }
        if (contextId.endsWith(".")) {
            LOGGER.warning("Context ids cannot end with dots");
            return;
        }
        if (contextId.isEmpty()) {
            contextId = UUID.randomUUID().toString();
        }
        if ((missingContextIdsCount = this.amountOfDotsInString(arcClass) - this.amountOfDotsInString(contextId)) < 0) {
            LOGGER.warning("Tried to export a context ID with more sub-contexts than in the given ARC class.");
            return;
        }
        StringBuilder contextBuilder = new StringBuilder().append(contextId);
        for (int i = 0; i < missingContextIdsCount; ++i) {
            contextBuilder.append(".");
            contextBuilder.append(UUID.randomUUID().toString());
        }
        contextId = contextBuilder.toString();
        HashMap<String, Object> output_inner_message = new HashMap<String, Object>(message);
        output_inner_message.put(MONA_ARC_CLASS_FIELD_NAME, arcClass);
        HashMap<String, Object> outerMessage = new HashMap<String, Object>();
        outerMessage.put("user_id", this.monaUserId);
        outerMessage.put("context", contextId);
        outerMessage.put("message", output_inner_message);
        outerMessage.put("export_timestamp", Instant.now().getEpochSecond());
        try {
            this.fluency.emit("mona.client.message", outerMessage);
        }
        catch (Exception e) {
            LOGGER.warning(String.format("IO Exception when emitting to fluentd: %s", e.getMessage()));
        }
    }

    public void exportStandalone(String arcClass, Map<String, Object> message) {
        this.exportStandalone(arcClass, "", message);
    }

    public void exportStandalone(String arcClass, List<Map<String, Object>> messages) {
        this.exportStandalone(arcClass, "", messages);
    }

    public void exportStandalone(String arcClass, String contextId, List<Map<String, Object>> messages) {
        if (messages == null) {
            LOGGER.warning("Tried to export null messages");
            return;
        }
        for (Map<String, Object> innerMessage : messages) {
            this.exportStandalone(arcClass, contextId, innerMessage);
        }
    }

    public void exportStandalone(String arcClass, String jsonString) {
        this.exportStandalone(arcClass, "", jsonString);
    }

    public void exportStandalone(String arcClass, String contextId, String jsonString) {
        if (jsonString == null) {
            LOGGER.warning("Tried to export null json String");
            return;
        }
        try {
            this.exportStandalone(arcClass, contextId, new JSONObject(jsonString));
        }
        catch (JSONException ex) {
            try {
                this.exportStandalone(arcClass, contextId, new JSONArray(jsonString));
            }
            catch (JSONException ex1) {
                LOGGER.warning("Bad Json String.");
            }
        }
    }

    public void exportStandalone(String arcClass, JSONObject jsonObject) {
        this.exportStandalone(arcClass, "", jsonObject);
    }

    public void exportStandalone(String arcClass, String contextId, JSONObject jsonObject) {
        if (jsonObject == null) {
            LOGGER.warning("Tried to export null JSONObject");
            return;
        }
        try {
            this.exportStandalone(arcClass, contextId, (Map)new ObjectMapper().readValue(jsonObject.toString(), HashMap.class));
        }
        catch (Exception e) {
            LOGGER.warning("Exception when trying to exportStandalone JSON object");
        }
    }

    public void exportStandalone(String arcClass, JSONArray jsonArray) {
        this.exportStandalone(arcClass, "", jsonArray);
    }

    public void exportStandalone(String arcClass, String contextId, JSONArray jsonArray) {
        if (jsonArray == null) {
            LOGGER.warning("Tried to export null JSONArray");
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.exportStandalone(arcClass, contextId, jsonArray.getJSONObject(i));
        }
    }

    public static class Builder {
        private static final int DEFAULT_BUFFER_CHUNK_INITIAL_SIZE = 0x800000;
        private static final int DEFAULT_BUFFER_CHUNK_RETENTION_SIZE = 0x1000000;
        private static final long DEFAULT_MAX_BUFFER_SIZE = 0x40000000L;
        private static final int DEFAULT_INTERVAL_MILLIS = 100;
        private final String host;
        private final int port;
        private final String monaUserId;
        private int bufferChunkInitialSize;
        private int bufferChunkRetentionSize;
        private long maxBufferSize;
        private int flushIntervalMillis;

        public Builder(String host, int port, String monaUserId) {
            this.host = host;
            this.port = port;
            this.monaUserId = monaUserId;
            this.bufferChunkInitialSize = 0x800000;
            this.bufferChunkRetentionSize = 0x1000000;
            this.maxBufferSize = 0x40000000L;
            this.flushIntervalMillis = 100;
        }

        public Builder setBufferChunkInitialSize(int bufferChunkInitialSize) {
            this.bufferChunkInitialSize = bufferChunkInitialSize;
            return this;
        }

        public Builder setBufferChunkRetentionSize(int bufferChunkRetentionSize) {
            this.bufferChunkRetentionSize = bufferChunkRetentionSize;
            return this;
        }

        public Builder setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Builder setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public MonaClient build() {
            return new MonaClient(this);
        }
    }
}

