/*
 * Decompiled with CFR 0.152.
 */
package io.monalabs.clients;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.komamitsu.fluency.Fluency;

public class MonaClient
implements Closeable {
    private static final String MONA_ARC_CLASS_FIELD_NAME = "MONA_ARC_CLASS";
    private static final Logger LOGGER = Logger.getLogger(MonaClient.class.getName());
    private final Fluency fluency;
    private final String monaUserId;

    protected MonaClient(Fluency fluency, String monaUserId) {
        this.fluency = fluency;
        this.monaUserId = monaUserId;
    }

    private MonaClient(Builder builder) {
        this(Fluency.defaultFluency((String)builder.host, (int)builder.port, (Fluency.Config)new Fluency.Config().setBufferChunkInitialSize(Integer.valueOf(builder.bufferChunkInitialSize)).setBufferChunkRetentionSize(Integer.valueOf(builder.bufferChunkRetentionSize)).setMaxBufferSize(Long.valueOf(builder.maxBufferSize)).setFlushIntervalMillis(Integer.valueOf(builder.flushIntervalMillis)).setSslEnabled(true)), builder.monaUserId);
    }

    @Override
    public void close() {
        try {
            this.fluency.close();
        }
        catch (IOException e) {
            LOGGER.warning(String.format("IO Exception when closing link to fluentd: %s", e.getMessage()));
        }
    }

    public void exportStandalone(String arcClass, Map<String, Object> innerMessage) {
        if (innerMessage.isEmpty()) {
            LOGGER.warning("Tried to export empty message");
            return;
        }
        if (arcClass == null || arcClass.isEmpty()) {
            LOGGER.warning("Tried to export with empty ARC class");
            return;
        }
        HashMap<String, Object> output_inner_message = new HashMap<String, Object>(innerMessage);
        output_inner_message.put(MONA_ARC_CLASS_FIELD_NAME, arcClass);
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("user_id", this.monaUserId);
        message.put("context", UUID.randomUUID().toString());
        message.put("message", output_inner_message);
        try {
            this.fluency.emit("mona.client.message", message);
        }
        catch (IOException e) {
            LOGGER.warning(String.format("IO Exception when emitting to fluentd: %s", e.getMessage()));
        }
    }

    public void exportStandalone(String arcClass, List<Map<String, Object>> innerMessages) {
        for (Map<String, Object> innerMessage : innerMessages) {
            this.exportStandalone(arcClass, innerMessage);
        }
    }

    public void exportStandalone(String arcClass, String jsonString) {
        try {
            this.exportStandalone(arcClass, new JSONObject(jsonString));
        }
        catch (JSONException ex) {
            try {
                this.exportStandalone(arcClass, new JSONArray(jsonString));
            }
            catch (JSONException ex1) {
                LOGGER.warning("Bad Json String.");
            }
        }
    }

    public void exportStandalone(String arcClass, JSONObject jsonObject) {
        try {
            this.exportStandalone(arcClass, (Map)new ObjectMapper().readValue(jsonObject.toString(), HashMap.class));
        }
        catch (IOException e) {
            LOGGER.warning("Exception when trying to exportStandalone JSON object");
        }
    }

    public void exportStandalone(String arcClass, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.exportStandalone(arcClass, jsonArray.getJSONObject(i));
        }
    }

    public static class Builder {
        private final String host;
        private final int port;
        private final String monaUserId;
        private int bufferChunkInitialSize;
        private int bufferChunkRetentionSize;
        private long maxBufferSize;
        private int flushIntervalMillis;

        public Builder(String host, int port, String monaUserId) {
            this.host = host;
            this.port = port;
            this.monaUserId = monaUserId;
            this.bufferChunkInitialSize = 0x800000;
            this.bufferChunkRetentionSize = 0x1000000;
            this.maxBufferSize = 0x10000000L;
            this.flushIntervalMillis = 100;
        }

        public Builder setBufferChunkInitialSize(int bufferChunkInitialSize) {
            this.bufferChunkInitialSize = bufferChunkInitialSize;
            return this;
        }

        public Builder setBufferChunkRetentionSize(int bufferChunkRetentionSize) {
            this.bufferChunkRetentionSize = bufferChunkRetentionSize;
            return this;
        }

        public Builder setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Builder setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public MonaClient build() {
            return new MonaClient(this);
        }
    }
}

