/*
 * Decompiled with CFR 0.152.
 */
package io.monalabs.clients;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.komamitsu.fluency.Fluency;

public class DefaultClient
implements Closeable {
    private static final String MONA_ARC_CLASS_FIELD_NAME = "MONA_ARC_CLASS";
    private static final Logger LOGGER = Logger.getLogger(DefaultClient.class.getName());
    private Fluency fluency;
    private final String monaUserId;

    public DefaultClient(String host, int port, String monaUserId) {
        this(Fluency.defaultFluency((String)host, (int)port, (Fluency.Config)new Fluency.Config().setBufferChunkInitialSize(Integer.valueOf(0x800000)).setBufferChunkRetentionSize(Integer.valueOf(0x1000000)).setMaxBufferSize(Long.valueOf(0x10000000L)).setFlushIntervalMillis(Integer.valueOf(0)).setSslEnabled(true)));
    }

    protected DefaultClient(Fluency fluency) {
        this.fluency = fluency;
        this.monaUserId = System.getenv("MONA_USER_ID");
    }

    @Override
    public void close() {
        try {
            this.fluency.close();
        }
        catch (IOException e) {
            LOGGER.warning(String.format("IO Exception when closing link to fluentd: %s", e.getMessage()));
        }
    }

    public void export(String arcClass, Map<String, Object> innerMessage) {
        if (innerMessage.isEmpty()) {
            return;
        }
        if (arcClass == null || arcClass.isEmpty()) {
            return;
        }
        HashMap<String, Object> output_inner_message = new HashMap<String, Object>(innerMessage);
        output_inner_message.put(MONA_ARC_CLASS_FIELD_NAME, arcClass);
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("user_id", this.monaUserId);
        message.put("context", UUID.randomUUID().toString());
        message.put("message", output_inner_message);
        try {
            this.fluency.emit("mona.client.message", message);
        }
        catch (IOException e) {
            LOGGER.warning(String.format("IO Exception when emitting to fluentd: %s", e.getMessage()));
        }
    }

    public void export(String arcClass, List<Map<String, Object>> innerMessages) {
        for (Map<String, Object> innerMessage : innerMessages) {
            this.export(arcClass, innerMessage);
        }
    }

    public void export(String arcClass, String jsonString) {
        try {
            this.export(arcClass, new JSONObject(jsonString));
        }
        catch (JSONException ex) {
            try {
                this.export(arcClass, new JSONArray(jsonString));
            }
            catch (JSONException ex1) {
                LOGGER.warning("Bad Json String.");
            }
        }
    }

    public void export(String arcClass, JSONObject jsonObject) {
        try {
            this.export(arcClass, (Map)new ObjectMapper().readValue(jsonObject.toString(), HashMap.class));
        }
        catch (IOException e) {
            LOGGER.warning("Exception when trying to export JSON object");
        }
    }

    public void export(String arcClass, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.export(arcClass, jsonArray.getJSONObject(i));
        }
    }
}

