/*
 * Decompiled with CFR 0.152.
 */
package io.mitter.sdk.java.support.interceptors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.mitter.sdk.java.objects.credentials.MitterUserTokenCredentials;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/mitter/sdk/java/support/interceptors/MitterUserTokenCredentialSetter;", "Lfeign/RequestInterceptor;", "userTokenCredentials", "Lio/mitter/sdk/java/objects/credentials/MitterUserTokenCredentials;", "(Lio/mitter/sdk/java/objects/credentials/MitterUserTokenCredentials;)V", "apply", "", "request", "Lfeign/RequestTemplate;", "getApplicationId", "", "Companion", "java-sdk"})
public final class MitterUserTokenCredentialSetter
implements RequestInterceptor {
    private final MitterUserTokenCredentials userTokenCredentials;
    private static final ObjectMapper objectMapper;
    @NotNull
    public static final String UserCredentialTokenHeaderKey = "X-Issued-Mitter-User-Authorization";
    @NotNull
    public static final String ApplicationIdHeaderKey = "X-Mitter-Application-Id";
    public static final Companion Companion;

    public void apply(@NotNull RequestTemplate request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        request.header(UserCredentialTokenHeaderKey, new String[]{this.userTokenCredentials.getSignedUserToken()});
        request.header(ApplicationIdHeaderKey, new String[]{this.getApplicationId()});
    }

    private final String getApplicationId() {
        if (this.userTokenCredentials.getApplicationId() != null) {
            return this.userTokenCredentials.getApplicationId();
        }
        List list = StringsKt.split$default((CharSequence)this.userTokenCredentials.getSignedUserToken(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        List it = list;
        if (it.size() != 3) {
            throw (Throwable)new IllegalArgumentException("The user jwt is invalid. Expected three period-separated parts");
        }
        byte[] byArray = Base64.getDecoder().decode((String)it.get(1));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(it[1])");
        byte[] byArray2 = byArray;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        String jwtJson = new String(byArray2, charset2);
        JsonNode jwtJsonNode = objectMapper.readTree(jwtJson);
        if (jwtJsonNode.get("applicationId") == null) {
            throw (Throwable)new IllegalArgumentException("You are using an old format of the JWT where applicationIds were not provided. This requires you to set an applicationId when creating the MitterUserTokenCredentialSetter, but one was not found on this instance.");
        }
        String string = jwtJsonNode.get("applicationId").asText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jwtJsonNode[\"applicationId\"].asText()");
        return string;
    }

    public MitterUserTokenCredentialSetter(@NotNull MitterUserTokenCredentials userTokenCredentials) {
        Intrinsics.checkParameterIsNotNull((Object)userTokenCredentials, (String)"userTokenCredentials");
        this.userTokenCredentials = userTokenCredentials;
    }

    static {
        Companion = new Companion(null);
        objectMapper = new ObjectMapper();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/mitter/sdk/java/support/interceptors/MitterUserTokenCredentialSetter$Companion;", "", "()V", "ApplicationIdHeaderKey", "", "UserCredentialTokenHeaderKey", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

