/*
 * Decompiled with CFR 0.152.
 */
package io.mitter.sdk.java.support.auth;

import io.mitter.sdk.java.support.auth.MitterCentralDigestGenerationArtifacts;
import io.mitter.sdk.java.support.auth.MitterCentralDigestParts;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0018\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lio/mitter/sdk/java/support/auth/MitterCentralDigestGenerator;", "", "()V", "base64Md5", "", "kotlin.jvm.PlatformType", "payload", "generateAuthorizationHeader", "digestParts", "Lio/mitter/sdk/java/support/auth/MitterCentralDigestParts;", "signingUser", "signingKey", "", "generateCentralDigest", "Lio/mitter/sdk/java/support/auth/MitterCentralDigestGenerationArtifacts;", "mitterCentralDigestParts", "getHmacSha1", "digestPayload", "instantToIsoDate", "instant", "Ljava/time/Instant;", "randomHex", "length", "", "Companion", "java-sdk"})
public final class MitterCentralDigestGenerator {
    private static final String HmacSha1AlgorithmKey = "HmacSHA1";
    private static final int DefaultNonceLength = 32;
    private static final SimpleDateFormat HttpIsoDateFormatObject;
    private static final String AuthorizationPrefix = "Auth";
    public static final Companion Companion;

    @NotNull
    public final MitterCentralDigestGenerationArtifacts generateCentralDigest(@NotNull MitterCentralDigestParts mitterCentralDigestParts, @NotNull String signingUser, @NotNull byte[] signingKey) {
        Intrinsics.checkParameterIsNotNull((Object)mitterCentralDigestParts, (String)"mitterCentralDigestParts");
        Intrinsics.checkParameterIsNotNull((Object)signingUser, (String)"signingUser");
        Intrinsics.checkParameterIsNotNull((Object)signingKey, (String)"signingKey");
        MitterCentralDigestParts finalizedDigestParts = mitterCentralDigestParts;
        if (mitterCentralDigestParts.getPayloadMd5() == null) {
            finalizedDigestParts = MitterCentralDigestParts.copy$default(finalizedDigestParts, null, null, null, null, null, null, this.base64Md5(mitterCentralDigestParts.getPayload()), 63, null);
        }
        if (mitterCentralDigestParts.getNonce() == null) {
            finalizedDigestParts = MitterCentralDigestParts.copy$default(finalizedDigestParts, null, null, null, this.randomHex(DefaultNonceLength), null, null, null, 119, null);
        }
        if (mitterCentralDigestParts.getDate() == null) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            finalizedDigestParts = MitterCentralDigestParts.copy$default(finalizedDigestParts, null, this.instantToIsoDate(instant), null, null, null, null, null, 125, null);
        }
        String authorizationHeader = this.generateAuthorizationHeader(finalizedDigestParts, signingUser, signingKey);
        String string = finalizedDigestParts.getNonce();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = finalizedDigestParts.getDate();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = finalizedDigestParts.getPayloadMd5();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        String string4 = string3;
        String string5 = authorizationHeader;
        String string6 = string2;
        return new MitterCentralDigestGenerationArtifacts(string, string4, string6, string5);
    }

    private final String generateAuthorizationHeader(MitterCentralDigestParts digestParts, String signingUser, byte[] signingKey) {
        String string;
        Object[] objectArray;
        String string2 = digestParts.getMethod();
        int n = 0;
        Object[] objectArray2 = objectArray = new String[6];
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        objectArray[n] = string = string4;
        Object[] objectArray3 = objectArray2;
        objectArray2[1] = digestParts.getContentType();
        objectArray3[2] = digestParts.getPayloadMd5();
        objectArray3[3] = digestParts.getDate();
        objectArray3[4] = digestParts.getPath();
        objectArray3[5] = digestParts.getNonce();
        String digestPayloadParts = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return AuthorizationPrefix + ' ' + signingUser + ':' + this.getHmacSha1(signingKey, digestPayloadParts);
    }

    private final String base64Md5(String payload) {
        return Base64.encodeBase64String((byte[])DigestUtils.md5((String)payload));
    }

    private final String getHmacSha1(byte[] signingKey, String digestPayload) {
        Mac mac = Mac.getInstance(HmacSha1AlgorithmKey);
        mac.init(new SecretKeySpec(signingKey, HmacSha1AlgorithmKey));
        String string = digestPayload;
        Mac mac2 = mac;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] rawHmac = mac2.doFinal(byArray2);
        String string3 = Base64.encodeBase64String((byte[])rawHmac);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.encodeBase64String(rawHmac)");
        return string3;
    }

    private final String randomHex(int length) {
        byte[] resBuf = new byte[length];
        new Random().nextBytes(resBuf);
        char[] cArray = Hex.encodeHex((byte[])resBuf);
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Hex.encodeHex(resBuf)");
        char[] cArray2 = cArray;
        return new String(cArray2);
    }

    private final String instantToIsoDate(Instant instant) {
        return HttpIsoDateFormatObject.format(Date.from(instant));
    }

    static {
        Companion = new Companion(null);
        HmacSha1AlgorithmKey = HmacSha1AlgorithmKey;
        DefaultNonceLength = 32;
        HttpIsoDateFormatObject = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        AuthorizationPrefix = AuthorizationPrefix;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/mitter/sdk/java/support/auth/MitterCentralDigestGenerator$Companion;", "", "()V", "AuthorizationPrefix", "", "DefaultNonceLength", "", "HmacSha1AlgorithmKey", "HttpIsoDateFormatObject", "Ljava/text/SimpleDateFormat;", "java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

