/*
 * Decompiled with CFR 0.152.
 */
package io.mitter.sdk.java.objects.credentials;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mitter.sdk.java.objects.credentials.CredentialsJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/mitter/sdk/java/objects/credentials/AccessKeyPair;", "", "credentialsJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/fasterxml/jackson/databind/JsonNode;)V", "Lio/mitter/sdk/java/objects/credentials/CredentialsJson;", "(Lio/mitter/sdk/java/objects/credentials/CredentialsJson;)V", "accessKey", "", "accessSecretBase64", "(Ljava/lang/String;Ljava/lang/String;)V", "getAccessKey", "()Ljava/lang/String;", "getAccessSecretBase64", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "java-sdk"})
public final class AccessKeyPair {
    @NotNull
    private final String accessKey;
    @NotNull
    private final String accessSecretBase64;

    @NotNull
    public final String getAccessKey() {
        return this.accessKey;
    }

    @NotNull
    public final String getAccessSecretBase64() {
        return this.accessSecretBase64;
    }

    public AccessKeyPair(@NotNull String accessKey, @NotNull String accessSecretBase64) {
        Intrinsics.checkParameterIsNotNull((Object)accessKey, (String)"accessKey");
        Intrinsics.checkParameterIsNotNull((Object)accessSecretBase64, (String)"accessSecretBase64");
        this.accessKey = accessKey;
        this.accessSecretBase64 = accessSecretBase64;
    }

    private AccessKeyPair(JsonNode credentialsJson) {
        String string = credentialsJson.get("accessKey").get("key").asText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"credentialsJson[\"accessKey\"][\"key\"].asText()");
        String string2 = credentialsJson.get("accessSecret").get("secret").asText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"credentialsJson[\"accessSecret\"][\"secret\"].asText()");
        this(string, string2);
    }

    public AccessKeyPair(@NotNull CredentialsJson credentialsJson) {
        Intrinsics.checkParameterIsNotNull((Object)credentialsJson, (String)"credentialsJson");
        JsonNode jsonNode = new ObjectMapper().readTree(credentialsJson.getJson());
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"ObjectMapper().readTree(credentialsJson.json)");
        this(jsonNode);
    }

    @NotNull
    public final String component1() {
        return this.accessKey;
    }

    @NotNull
    public final String component2() {
        return this.accessSecretBase64;
    }

    @NotNull
    public final AccessKeyPair copy(@NotNull String accessKey, @NotNull String accessSecretBase64) {
        Intrinsics.checkParameterIsNotNull((Object)accessKey, (String)"accessKey");
        Intrinsics.checkParameterIsNotNull((Object)accessSecretBase64, (String)"accessSecretBase64");
        return new AccessKeyPair(accessKey, accessSecretBase64);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AccessKeyPair copy$default(AccessKeyPair accessKeyPair, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = accessKeyPair.accessKey;
        }
        if ((n & 2) != 0) {
            string2 = accessKeyPair.accessSecretBase64;
        }
        return accessKeyPair.copy(string, string2);
    }

    public String toString() {
        return "AccessKeyPair(accessKey=" + this.accessKey + ", accessSecretBase64=" + this.accessSecretBase64 + ")";
    }

    public int hashCode() {
        String string = this.accessKey;
        String string2 = this.accessSecretBase64;
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AccessKeyPair)) break block3;
                AccessKeyPair accessKeyPair = (AccessKeyPair)object;
                if (!Intrinsics.areEqual((Object)this.accessKey, (Object)accessKeyPair.accessKey) || !Intrinsics.areEqual((Object)this.accessSecretBase64, (Object)accessKeyPair.accessSecretBase64)) break block3;
            }
            return true;
        }
        return false;
    }
}

