package io.mitter.sdk.java.clients

import com.fasterxml.jackson.databind.JsonNode
import feign.Headers
import feign.Param
import feign.QueryMap
import feign.RequestLine
import io.mitter.data.domain.annotations.Identifiable
import io.mitter.mardle.models.BulkMessageResponse
import io.mitter.models.mardle.messaging.Channel
import io.mitter.models.mardle.messaging.Message
import io.mitter.models.mardle.messaging.TimelineEvent
import io.mitter.models.mardle.wire.ChannelMessage
import io.mitter.models.mardle.wire.MessageTimelineEvent
import io.mitter.named.resources.http.endpoints.ChannelEndpointsV1
import io.mitter.named.resources.http.endpoints.ChannelMessageEndpointsV1
import io.mitter.named.resources.http.endpoints.MessageEndpointsV1
import io.mitter.sdk.java.support.IdentifiableExpander
import io.mitter.sdk.java.utils.StandardHeaderLines
import io.mitter.spi.java.clients.BinaryPayload
import io.mitter.spi.java.clients.MitterMessagesClient

/**
 *
 * @author Rohan Prabhu (rohan@mitter.io)
 */

@Headers(StandardHeaderLines.AcceptApplicationJson)
interface HttpMitterMessagesClient : MitterMessagesClient {
    @RequestLine("POST ${MessageEndpointsV1.Base}")
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun sendMessages(messages: List<ChannelMessage>): BulkMessageResponse {
        throw UnsupportedOperationException("This API is not currently supported.")
    }

    @RequestLine("POST " + ChannelMessageEndpointsV1.Base)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun sendMessageToChannel(
        @Param(ChannelEndpointsV1.ChannelIdParam, expander = IdentifiableExpander::class)
        channelId: Identifiable<Channel>, message: Message
    ) : Message

    @RequestLine("POST " + ChannelMessageEndpointsV1.Base)
    @Headers(StandardHeaderLines.ContentTypeMultipartFormData + ";charset=utf-8")
    override fun sendMessageToChannel(
        @Param(ChannelEndpointsV1.ChannelIdParam, expander = IdentifiableExpander::class)
        channelId: Identifiable<Channel>,
        @Param("io.mitter.wire.requestbody;application/json")
        message: Message,
        @Param("binary-payloads")
        upload: List<BinaryPayload>
    ) : Message

    @RequestLine("GET " + ChannelMessageEndpointsV1.Base)
    override fun getMessagesFromChannel(
        @Param(ChannelEndpointsV1.ChannelIdParam, expander = IdentifiableExpander::class)
        channelId: Identifiable<Channel>,
        @QueryMap queryMap: Map<String, Any>
    ) : List<Message>


    @RequestLine("DELETE " + ChannelMessageEndpointsV1.Specified.ForMessageIds)
    override fun removeMessagesFromChannel(
        @Param(ChannelEndpointsV1.ChannelIdParam, expander = IdentifiableExpander::class)
        channelId: Identifiable<Channel>,
        @Param(ChannelMessageEndpointsV1.MessageIdsParam)
        messageIds: String
    ) : List<Message>

    @RequestLine("GET " + MessageEndpointsV1.Specified.ById)
    override fun getMessageByMessageId(
        @Param(MessageEndpointsV1.MessageIdParam, expander = IdentifiableExpander::class)
        messageId: Identifiable<Message>
    ) : Message

    /* ~~ Channel's Messages Timeline event operations ~~ */

    @RequestLine("POST " + ChannelMessageEndpointsV1.TimelineEvents.ForMessageIds)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun addTimelineEventForMessage(
        @Param(ChannelEndpointsV1.ChannelIdParam, expander = IdentifiableExpander::class)
        channelId: Identifiable<Channel>,
        @Param(ChannelMessageEndpointsV1.MessageIdsParam)
        messageIdsCsv: String,
        timelineEvent: TimelineEvent
    ) : Identifiable<TimelineEvent>

    @RequestLine("GET " + ChannelMessageEndpointsV1.TimelineEvents.EventTypeFilter.ByEventType)
    override fun getTimelineEventForMessage(
        @Param(ChannelMessageEndpointsV1.TimelineEvents.EventTypeFilter.EventTypeFilterParam) eventTypeFilterCsv:String,
        @Param(ChannelEndpointsV1.ChannelIdParam, expander = IdentifiableExpander::class)
        channelId: Identifiable<Channel>,
        @Param(ChannelMessageEndpointsV1.MessageIdsParam)
        messageIdsCsv: String
    ) : List<MessageTimelineEvent>

    /* Channel Metadata Operations  */

    @RequestLine("GET " + ChannelMessageEndpointsV1.Base)
    override fun getMessagesWithMetadata(
            @Param(ChannelEndpointsV1.ChannelIdParam, expander = IdentifiableExpander::class)
            channelId: Identifiable<Channel>,
            @QueryMap queryMap: Map<String, Any> ): List<Message>

    @RequestLine("POST " + MessageEndpointsV1.Metadata.ForMessageId)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun addMessageMetadata(
            @Param(MessageEndpointsV1.MessageIdParam, expander = IdentifiableExpander::class)
            messageId: Identifiable<Message>,
            metadata: JsonNode
    )
}
