package io.mitter.sdk.java.clients

import feign.Headers
import feign.Param
import feign.RequestLine
import io.mitter.data.domain.entity.Attribute
import io.mitter.data.domain.entity.AttributeDef
import io.mitter.data.domain.entity.EntityProfile
import io.mitter.models.hosted.PatchEntityProfile
import io.mitter.named.resources.http.endpoints.EntityProfileEndpointsV1
import io.mitter.sdk.java.utils.StandardHeaderLines
import io.mitter.spi.java.clients.MitterEntityProfileClient

/**
 *
 * @author Ankush Kumar(ankush@mitter.io) on 02/2018
 *
 */

@Headers(StandardHeaderLines.AcceptApplicationJson)
interface HttpMitterEntityProfileClient : MitterEntityProfileClient {
    @RequestLine("GET " + EntityProfileEndpointsV1.Profile.Base)
    override fun getEntityProfile(
        @Param(EntityProfileEndpointsV1.EntityTypeParam) entityType: String,
        @Param(EntityProfileEndpointsV1.EntityIdParam) entityId: String
    ) : EntityProfile

    @RequestLine("GET " + EntityProfileEndpointsV1.Profile.Specified.ByAttributeKeys)
    override fun getAttributesInProfile(
        @Param(EntityProfileEndpointsV1.EntityTypeParam) entityType: String,
        @Param(EntityProfileEndpointsV1.EntityIdParam) entityId: String,
        @Param(EntityProfileEndpointsV1.AttributeKeysParam) keys: String
    ) : List<Attribute>

    @RequestLine("POST " + EntityProfileEndpointsV1.Profile.Base)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun setEntityProfile(
        @Param(EntityProfileEndpointsV1.EntityTypeParam) entityType: String,
        @Param(EntityProfileEndpointsV1.EntityIdParam) entityId: String,
        patchEntityProfile: PatchEntityProfile
    )

    @RequestLine("POST " + EntityProfileEndpointsV1.Profile.Specified.ByAttributeKey)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun addAttributeToProfile(
        @Param(EntityProfileEndpointsV1.EntityTypeParam) entityType: String,
        @Param(EntityProfileEndpointsV1.EntityIdParam) entityId: String,
        @Param(EntityProfileEndpointsV1.AttributeKeyParam) key: String,
        attribute: Attribute
    )

    @RequestLine("POST " + EntityProfileEndpointsV1.AttributeDef.Base)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun addAttributeDef(
        @Param(EntityProfileEndpointsV1.EntityTypeParam) entityType: String,
        attributeDef: AttributeDef
    )

    @RequestLine("GET " + EntityProfileEndpointsV1.AttributeDef.Specified.ByAttributeKey)
    override fun getAttributeDef(
        @Param(EntityProfileEndpointsV1.EntityTypeParam) entityType: String,
        @Param(EntityProfileEndpointsV1.AttributeKeyParam) key: String
    ) : AttributeDef

    @RequestLine("GET " + EntityProfileEndpointsV1.AttributeDef.Base)
    override fun getAllAttributeDefs(
        @Param(EntityProfileEndpointsV1.EntityTypeParam) entityType: String
    ) : List<AttributeDef>
}
