package io.mitter.sdk.java.clients

import feign.Headers
import feign.RequestLine
import io.mitter.models.hosted.CountsResponse
import io.mitter.models.leprechaun.CountClass
import io.mitter.named.resources.http.endpoints.CountsEndpointsV1
import io.mitter.sdk.java.utils.StandardHeaderLines
import io.mitter.spi.java.clients.MitterCountsClient

/**
 *
 * @author shouvik
 */
@Headers(StandardHeaderLines.AcceptApplicationJson)
interface HttpMitterCountsClient: MitterCountsClient {

    @RequestLine("GET " + CountsEndpointsV1.Specified.ByClass)
    override fun getCount(
        countClass: CountClass, subject2: String?, subject3: String?, subject4: String?
    ): CountsResponse

    override fun updateCount(
        countOffset: Long, countClass: CountClass, subject1: String?,
        subject2: String?, subject3: String?, subject4: String?
    )

    override fun setCount(
        countValue: Long, countClass: CountClass, subject1: String?,
        subject2: String?, subject3: String?, subject4: String?
    )
}
