package io.mitter.sdk.java.clients

import feign.Headers
import feign.RequestLine
import io.mitter.models.hosted.subscriber.auth.SubscriberSignupRequestInternal
import io.mitter.models.hosted.subscriber.auth.SubscriberSignupResponseInternal
import io.mitter.models.requests.SubscriberAuthRequest
import io.mitter.models.requests.SubscriberAuthResponse
import io.mitter.named.resources.http.endpoints.SubscriberEndpointsV1
import io.mitter.sdk.java.utils.StandardHeaderLines
import io.mitter.spi.java.clients.MitterAuthenticationEndpointsClient

/**
 *
 * @author Ankush Kumar(ankush@mitter.io) on 02/2018
 *
 */

@Headers(StandardHeaderLines.AcceptApplicationJson)
interface HttpMitterAuthenticationEndpointsClient : MitterAuthenticationEndpointsClient {
    @RequestLine("POST " + SubscriberEndpointsV1.Subscribers.Token.Base)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun authenticateSubscriber(
        subscriberAuthRequest: SubscriberAuthRequest
    ) : SubscriberAuthResponse

    @RequestLine("POST " + SubscriberEndpointsV1.Subscribers.Ancillary.Signup)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun signupSubscriber(
        subscriberSignupRequestInternal: SubscriberSignupRequestInternal
    ) : SubscriberSignupResponseInternal

    @RequestLine("GET "+ SubscriberEndpointsV1.Subscribers.Auth.Logout)
    override fun logoutSubscriber()

    @RequestLine("DELETE "+ SubscriberEndpointsV1.Subscribers.Token.Base)
    override fun revokeAllTokens() : List<String>
}
