package io.mitter.sdk.java.clients

import feign.Headers
import feign.Param
import feign.RequestLine
import io.mitter.data.domain.annotations.Identifiable
import io.mitter.data.domain.application.Application
import io.mitter.data.domain.application.ApplicationProfile
import io.mitter.data.domain.application.SubscriberApplication
import io.mitter.named.resources.http.endpoints.ApplicationEndpointsV1
import io.mitter.sdk.java.support.IdentifiableExpander
import io.mitter.sdk.java.utils.StandardHeaderLines
import io.mitter.spi.java.clients.MitterApplicationClient

/**
 *
 * @author Ankush Kumar(ankush@mitter.io) on 02/2018
 *
 */

@Headers(StandardHeaderLines.AcceptApplicationJson)
interface HttpMitterApplicationClient : MitterApplicationClient {
    @RequestLine("POST " + ApplicationEndpointsV1.Applications.Base)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun addApplication(
        subscriberApplication: SubscriberApplication
    ) : SubscriberApplication

    @RequestLine("GET " + ApplicationEndpointsV1.Applications.Base)
    override fun getApplications() : List<SubscriberApplication>

    @RequestLine("GET " + ApplicationEndpointsV1.Applications.Specified.Base)
    override fun getApplicationWithId(
        @Param(ApplicationEndpointsV1.Applications.IdParam, expander = IdentifiableExpander::class)
        applicationId: Identifiable<Application>
    ) : SubscriberApplication

    @RequestLine("DELETE " + ApplicationEndpointsV1.Applications.Specified.Base)
    override fun deleteApplication(
        @Param(ApplicationEndpointsV1.Applications.IdParam, expander = IdentifiableExpander::class)
        applicationId: Identifiable<Application>
    )

    @RequestLine("GET " + ApplicationEndpointsV1.Applications.Specified.Profile)
    override fun getApplicationProfile(
        @Param(ApplicationEndpointsV1.Applications.IdParam, expander = IdentifiableExpander::class)
        applicationId: Identifiable<Application>
    ) : SubscriberApplication

    @RequestLine("PUT " + ApplicationEndpointsV1.Applications.Specified.Profile)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun setApplicationProfile(
        applicationProfile: ApplicationProfile,
        @Param(ApplicationEndpointsV1.Applications.IdParam, expander = IdentifiableExpander::class)
        applicationId: Identifiable<Application>
    )
}
