package io.mitter.sdk.java.clients

import feign.Headers
import feign.Param
import feign.RequestLine
import io.mitter.auth.data.domain.credential.accesscredential.AccessCredential
import io.mitter.auth.data.domain.credential.accesscredential.AccessCredentialStub
import io.mitter.data.domain.annotations.Identifiable
import io.mitter.data.domain.application.Application
import io.mitter.named.resources.http.endpoints.ApplicationEndpointsV1
import io.mitter.sdk.java.support.IdentifiableExpander
import io.mitter.sdk.java.utils.StandardHeaderLines
import io.mitter.spi.java.clients.MitterApplicationAccessKeyClient

/**
 *
 * @author Ankush Kumar(ankush@mitter.io) on 02/2018
 *
 */

@Headers(StandardHeaderLines.AcceptApplicationJson)
interface HttpMitterApplicationAccessKeyClient : MitterApplicationAccessKeyClient {
    @RequestLine("POST " + ApplicationEndpointsV1.AccessKeys.Base)
    @Headers(StandardHeaderLines.ContentTypeApplicationJson)
    override fun newAccessKey(
        @Param(ApplicationEndpointsV1.Applications.IdParam , expander = IdentifiableExpander::class)
        applicationId: Identifiable<Application>
    ) : AccessCredential

    @RequestLine("GET " + ApplicationEndpointsV1.AccessKeys.Base)
    override fun getAccessKeys(
        @Param(ApplicationEndpointsV1.Applications.IdParam , expander = IdentifiableExpander::class)
        applicationId: Identifiable<Application>
    ) : List<AccessCredentialStub>

    @RequestLine("DELETE " + ApplicationEndpointsV1.AccessKeys.Specified.Base)
    override fun deleteAccessKeys(
        @Param(ApplicationEndpointsV1.Applications.IdParam , expander = IdentifiableExpander::class)
        applicationId: Identifiable<Application>,
        @Param(ApplicationEndpointsV1.AccessKeys.AccessKeyParam) accessKey: String
    )
}
