package io.mitter.sdk.java.clients

import com.fasterxml.jackson.databind.node.ObjectNode
import feign.Headers
import feign.RequestLine
import io.mitter.sdk.java.utils.StandardHeaderLines
import io.mitter.spi.java.clients.MitterAccessKeyTestClient

/**
 *
 * @author Rohan Prabhu (rohan@rohanprabhu.com)
 */
@Headers(StandardHeaderLines.AcceptApplicationJson)
interface HttpMitterAccessKeyTestClient : MitterAccessKeyTestClient {
    @RequestLine("GET /v1/test/application/by/accesskey")
    override fun testGetWithApplicationAccessKey() : ObjectNode

    @RequestLine("POST /v1/test/application/by/accesskey")
    @Headers("Content-Type: application/json")
    override fun testPostWithApplicationAccessKey(requestObject: ObjectNode) : ObjectNode

    @RequestLine("GET /v1/test/subscriber/by/accesskey")
    override fun testGetWithSubscriberAccessKey() : ObjectNode

    @RequestLine("POST /v1/test/subscriber/by/accesskey")
    @Headers("Content-Type: application/json")
    override fun testPostWithSubscriberAccessKey(requestObject: ObjectNode) : ObjectNode
}
