/*
 * Decompiled with CFR 0.152.
 */
package io.minio.spark.benchmarks.dfsio;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.minio.spark.benchmarks.dfsio.BuildInfo$;
import io.minio.spark.benchmarks.dfsio.Clean$;
import io.minio.spark.benchmarks.dfsio.NotDefined$;
import io.minio.spark.benchmarks.dfsio.Read$;
import io.minio.spark.benchmarks.dfsio.TestDFSIOConf;
import io.minio.spark.benchmarks.dfsio.TestDFSIOConf$;
import io.minio.spark.benchmarks.dfsio.TestDFSIOConfParser$;
import io.minio.spark.benchmarks.dfsio.TestMode;
import io.minio.spark.benchmarks.dfsio.Write$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.matching.Regex;
import scopt.OptionDef;
import scopt.OptionParser;

public final class TestDFSIOConfParser$
implements LazyLogging {
    public static final TestDFSIOConfParser$ MODULE$;
    private OptionParser<TestDFSIOConf> parser;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new TestDFSIOConfParser$();
    }

    private OptionParser parser$lzycompute() {
        TestDFSIOConfParser$ testDFSIOConfParser$ = this;
        synchronized (testDFSIOConfParser$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.parser = new OptionParser<TestDFSIOConf>(){
                    private final Regex SizePattern;

                    private Regex SizePattern() {
                        return this.SizePattern;
                    }

                    public Either<String, BoxedUnit> io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$validateSize(String size) {
                        return size.matches(this.SizePattern().toString()) ? this.success() : this.failure("The size must be valid");
                    }

                    public long io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$sizeToBytes(String size) {
                        List units = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "kb", "mb", "gb"}));
                        Regex.Match matcher = (Regex.Match)this.SizePattern().findFirstMatchIn((CharSequence)size).get();
                        String value = matcher.group(1);
                        String unit = matcher.group(2).toLowerCase();
                        return (long)((double)new StringOps(Predef$.MODULE$.augmentString(value)).toFloat() * package$.MODULE$.pow(2.0, (double)(units.indexOf((Object)unit) * 10)));
                    }
                    {
                        this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test DFS I/O ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BuildInfo$.MODULE$.version()}))}));
                        this.cmd("write").text(new StringOps(Predef$.MODULE$.augmentString("Runs a test writing to the cluster. The written files are located in the DFS under the folder\n        |defined by the option <outputDir>. If the folder already exists, it will be first deleted.\n      ")).stripMargin()).action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(BoxedUnit x$1, TestDFSIOConf c) {
                                return c.copy(Write$.MODULE$, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7());
                            }
                        }).children((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.opt("numFiles", scopt.Read$.MODULE$.intRead()).required().valueName("<value>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(int n, TestDFSIOConf c) {
                                int x$4 = n;
                                TestMode x$5 = c.copy$default$1();
                                long x$6 = c.copy$default$3();
                                String x$7 = c.copy$default$4();
                                String x$8 = c.copy$default$5();
                                int x$9 = c.copy$default$6();
                                Map<String, String> x$10 = c.copy$default$7();
                                return c.copy(x$5, x$4, x$6, x$7, x$8, x$9, x$10);
                            }
                        }).text("Number of files to write. Default to 4."), this.opt("fileSize", scopt.Read$.MODULE$.stringRead()).required().valueName("<value>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final TestDFSIOConf apply(String s, TestDFSIOConf c) {
                                long x$11 = this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$sizeToBytes(s);
                                TestMode x$12 = c.copy$default$1();
                                int x$13 = c.copy$default$2();
                                String x$14 = c.copy$default$4();
                                String x$15 = c.copy$default$5();
                                int x$16 = c.copy$default$6();
                                Map<String, String> x$17 = c.copy$default$7();
                                return c.copy(x$12, x$13, x$11, x$14, x$15, x$16, x$17);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).validate((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final Either<String, BoxedUnit> apply(String size) {
                                return this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$validateSize(size);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).text("Size of each file to write (B|KB|MB|GB). Default to 1MB."), this.opt("outputDir", scopt.Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(String o, TestDFSIOConf c) {
                                String x$18 = o;
                                TestMode x$19 = c.copy$default$1();
                                int x$20 = c.copy$default$2();
                                long x$21 = c.copy$default$3();
                                String x$22 = c.copy$default$5();
                                int x$23 = c.copy$default$6();
                                Map<String, String> x$24 = c.copy$default$7();
                                return c.copy(x$19, x$20, x$21, x$18, x$22, x$23, x$24);
                            }
                        }).text("Name of the directory to place the resultant files. Default to /benchmarks/DFSIO"), this.opt("resFile", scopt.Read$.MODULE$.stringRead()).optional().valueName("<fileName>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(String r, TestDFSIOConf c) {
                                String x$25 = r;
                                TestMode x$26 = c.copy$default$1();
                                int x$27 = c.copy$default$2();
                                long x$28 = c.copy$default$3();
                                String x$29 = c.copy$default$4();
                                int x$30 = c.copy$default$6();
                                Map<String, String> x$31 = c.copy$default$7();
                                return c.copy(x$26, x$27, x$28, x$29, x$25, x$30, x$31);
                            }
                        }).text("Name of the local file in the current local directory where to append the benchmark results."), this.opt("bufferSize", scopt.Read$.MODULE$.stringRead()).optional().valueName("<value>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final TestDFSIOConf apply(String s, TestDFSIOConf c) {
                                long x$32 = this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$sizeToBytes(s);
                                TestMode x$33 = c.copy$default$1();
                                int x$34 = c.copy$default$2();
                                String x$35 = c.copy$default$4();
                                String x$36 = c.copy$default$5();
                                int x$37 = c.copy$default$6();
                                Map<String, String> x$38 = c.copy$default$7();
                                return c.copy(x$33, x$34, x$32, x$35, x$36, x$37, x$38);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).validate((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final Either<String, BoxedUnit> apply(String size) {
                                return this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$validateSize(size);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).text("Size of each file to write (B|KB|MB|GB). Default to 1MB."), this.opt("hadoopProps", scopt.Read$.MODULE$.mapRead(scopt.Read$.MODULE$.stringRead(), scopt.Read$.MODULE$.stringRead())).optional().valueName("k1=v1,k2=v2...").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(Map<String, String> p, TestDFSIOConf c) {
                                Map<String, String> x$39 = p;
                                TestMode x$40 = c.copy$default$1();
                                int x$41 = c.copy$default$2();
                                long x$42 = c.copy$default$3();
                                String x$43 = c.copy$default$4();
                                String x$44 = c.copy$default$5();
                                int x$45 = c.copy$default$6();
                                return c.copy(x$40, x$41, x$42, x$43, x$44, x$45, x$39);
                            }
                        }).text("Extra hadoop configuration properties")}));
                        this.cmd("read").text(new StringOps(Predef$.MODULE$.augmentString("Runs a test reading from the cluster. It is convenient to run test with command write first, so that some\n        |files are prepared for read test. If the test is run with this command before it is run with command write,\n        |an error message will be shown up.\n      ")).stripMargin()).action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(BoxedUnit x$2, TestDFSIOConf c) {
                                return c.copy(Read$.MODULE$, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7());
                            }
                        }).children((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.opt("numFiles", scopt.Read$.MODULE$.intRead()).required().valueName("<value>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(int n, TestDFSIOConf c) {
                                int x$46 = n;
                                TestMode x$47 = c.copy$default$1();
                                long x$48 = c.copy$default$3();
                                String x$49 = c.copy$default$4();
                                String x$50 = c.copy$default$5();
                                int x$51 = c.copy$default$6();
                                Map<String, String> x$52 = c.copy$default$7();
                                return c.copy(x$47, x$46, x$48, x$49, x$50, x$51, x$52);
                            }
                        }).text("Number of files to read. Default to 4."), this.opt("fileSize", scopt.Read$.MODULE$.stringRead()).required().valueName("<value>").validate((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final Either<String, BoxedUnit> apply(String size) {
                                return this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$validateSize(size);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final TestDFSIOConf apply(String s, TestDFSIOConf c) {
                                long x$53 = this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$sizeToBytes(s);
                                TestMode x$54 = c.copy$default$1();
                                int x$55 = c.copy$default$2();
                                String x$56 = c.copy$default$4();
                                String x$57 = c.copy$default$5();
                                int x$58 = c.copy$default$6();
                                Map<String, String> x$59 = c.copy$default$7();
                                return c.copy(x$54, x$55, x$53, x$56, x$57, x$58, x$59);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).text("Size of each file to read (B|KB|MB|GB). Default to 128B."), this.opt("inputDir", scopt.Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(String o, TestDFSIOConf c) {
                                String x$60 = o;
                                TestMode x$61 = c.copy$default$1();
                                int x$62 = c.copy$default$2();
                                long x$63 = c.copy$default$3();
                                String x$64 = c.copy$default$5();
                                int x$65 = c.copy$default$6();
                                Map<String, String> x$66 = c.copy$default$7();
                                return c.copy(x$61, x$62, x$63, x$60, x$64, x$65, x$66);
                            }
                        }).text("Name of the directory where to find the files to read. Default to /benchmarks/DFSIO"), this.opt("resFile", scopt.Read$.MODULE$.stringRead()).optional().valueName("<fileName>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(String r, TestDFSIOConf c) {
                                String x$67 = r;
                                TestMode x$68 = c.copy$default$1();
                                int x$69 = c.copy$default$2();
                                long x$70 = c.copy$default$3();
                                String x$71 = c.copy$default$4();
                                int x$72 = c.copy$default$6();
                                Map<String, String> x$73 = c.copy$default$7();
                                return c.copy(x$68, x$69, x$70, x$71, x$67, x$72, x$73);
                            }
                        }).text("Name of the local file in the current local directory where to append the benchmark results."), this.opt("bufferSize", scopt.Read$.MODULE$.stringRead()).optional().valueName("<value>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final TestDFSIOConf apply(String s, TestDFSIOConf c) {
                                long x$74 = this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$sizeToBytes(s);
                                TestMode x$75 = c.copy$default$1();
                                int x$76 = c.copy$default$2();
                                String x$77 = c.copy$default$4();
                                String x$78 = c.copy$default$5();
                                int x$79 = c.copy$default$6();
                                Map<String, String> x$80 = c.copy$default$7();
                                return c.copy(x$75, x$76, x$74, x$77, x$78, x$79, x$80);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).validate((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final Either<String, BoxedUnit> apply(String size) {
                                return this.$outer.io$minio$spark$benchmarks$dfsio$TestDFSIOConfParser$$anon$$validateSize(size);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).text("Size of each file to write (B|KB|MB|GB). Default to 1MB."), this.opt("hadoopProps", scopt.Read$.MODULE$.mapRead(scopt.Read$.MODULE$.stringRead(), scopt.Read$.MODULE$.stringRead())).optional().valueName("k1=v1,k2=v2...").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(Map<String, String> p, TestDFSIOConf c) {
                                Map<String, String> x$81 = p;
                                TestMode x$82 = c.copy$default$1();
                                int x$83 = c.copy$default$2();
                                long x$84 = c.copy$default$3();
                                String x$85 = c.copy$default$4();
                                String x$86 = c.copy$default$5();
                                int x$87 = c.copy$default$6();
                                return c.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$81);
                            }
                        }).text("Extra hadoop configuration properties")}));
                        this.cmd("clean").text("Remove previous test data. This command deletes de output directory.").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(BoxedUnit x$3, TestDFSIOConf c) {
                                return c.copy(Clean$.MODULE$, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7());
                            }
                        }).children((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.opt("outputDir", scopt.Read$.MODULE$.stringRead()).required().valueName("<file>").action((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TestDFSIOConf apply(String o, TestDFSIOConf c) {
                                String x$88 = o;
                                TestMode x$89 = c.copy$default$1();
                                int x$90 = c.copy$default$2();
                                long x$91 = c.copy$default$3();
                                String x$92 = c.copy$default$5();
                                int x$93 = c.copy$default$6();
                                Map<String, String> x$94 = c.copy$default$7();
                                return c.copy(x$89, x$90, x$91, x$88, x$92, x$93, x$94);
                            }
                        }).text("Name of the directory to clean. Default to /benchmarks/DFSIO")}));
                        this.checkConfig((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final Either<String, BoxedUnit> apply(TestDFSIOConf conf) {
                                TestMode testMode = conf.mode();
                                NotDefined$ notDefined$ = NotDefined$.MODULE$;
                                return !(testMode != null ? !testMode.equals(notDefined$) : notDefined$ != null) ? this.$outer.failure("A command is required.") : this.$outer.success();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.help("help").text("prints this usage text");
                        this.version("version");
                        this.SizePattern = new StringOps(Predef$.MODULE$.augmentString("^(\\d+(?:\\.\\d+)?)(([kKmMgG]?[bB]))$")).r();
                    }
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.parser;
        }
    }

    private Logger logger$lzycompute() {
        TestDFSIOConfParser$ testDFSIOConfParser$ = this;
        synchronized (testDFSIOConfParser$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private OptionParser<TestDFSIOConf> parser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.parser$lzycompute() : this.parser;
    }

    public void parseAndRun(Seq<String> args, Function1<TestDFSIOConf, BoxedUnit> runFunc) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = this.parser().parse(args, (Object)new TestDFSIOConf(TestDFSIOConf$.MODULE$.apply$default$1(), TestDFSIOConf$.MODULE$.apply$default$2(), TestDFSIOConf$.MODULE$.apply$default$3(), TestDFSIOConf$.MODULE$.apply$default$4(), TestDFSIOConf$.MODULE$.apply$default$5(), TestDFSIOConf$.MODULE$.apply$default$6(), TestDFSIOConf$.MODULE$.apply$default$7()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    TestDFSIOConf conf = (TestDFSIOConf)some.x();
                    this.printOptions(conf);
                    BoxedUnit boxedUnit = (BoxedUnit)runFunc.apply((Object)conf);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private void printOptions(TestDFSIOConf conf) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)((Object)TestDFSIOConf$.MODULE$)).getClass().getSimpleName(), BuildInfo$.MODULE$.version()})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Test mode = {}", new Object[]{conf.mode().command()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TestMode testMode = conf.mode();
        if (Write$.MODULE$.equals(testMode)) {
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            BoxedUnit boxedUnit7;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("outputDir = {}", new Object[]{conf.benchmarkDir()});
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("resFile = {}", new Object[]{conf.resFileName()});
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("numFiles = {}", (Object)BoxesRunTime.boxToInteger((int)conf.numFiles()));
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("fileSize = {}", (Object)BoxesRunTime.boxToLong((long)conf.fileSize()));
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("bufferSize = {}", (Object)BoxesRunTime.boxToInteger((int)conf.bufferSize()));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit3;
        } else if (Read$.MODULE$.equals(testMode)) {
            BoxedUnit boxedUnit9;
            BoxedUnit boxedUnit10;
            BoxedUnit boxedUnit11;
            BoxedUnit boxedUnit12;
            BoxedUnit boxedUnit13;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("inputDir = {}", new Object[]{conf.benchmarkDir()});
                boxedUnit13 = BoxedUnit.UNIT;
            } else {
                boxedUnit13 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("resFile = {}", new Object[]{conf.resFileName()});
                boxedUnit12 = BoxedUnit.UNIT;
            } else {
                boxedUnit12 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("numFiles = {}", (Object)BoxesRunTime.boxToInteger((int)conf.numFiles()));
                boxedUnit11 = BoxedUnit.UNIT;
            } else {
                boxedUnit11 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("fileSize = {}", (Object)BoxesRunTime.boxToLong((long)conf.fileSize()));
                boxedUnit10 = BoxedUnit.UNIT;
            } else {
                boxedUnit10 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("bufferSize = {}", (Object)BoxesRunTime.boxToInteger((int)conf.bufferSize()));
                boxedUnit9 = BoxedUnit.UNIT;
            } else {
                boxedUnit9 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit14 = boxedUnit9;
        } else if (Clean$.MODULE$.equals(testMode)) {
            BoxedUnit boxedUnit15;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("outputDir = {}", new Object[]{conf.benchmarkDir()});
                boxedUnit15 = BoxedUnit.UNIT;
            } else {
                boxedUnit15 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit16 = boxedUnit15;
        } else {
            BoxedUnit boxedUnit17 = BoxedUnit.UNIT;
        }
    }

    private TestDFSIOConfParser$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

