/*
 * Decompiled with CFR 0.152.
 */
package io.minio.spark.benchmarks.dfsio;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.minio.spark.benchmarks.dfsio.Clean$;
import io.minio.spark.benchmarks.dfsio.ControlFilesCreator$;
import io.minio.spark.benchmarks.dfsio.IOReader;
import io.minio.spark.benchmarks.dfsio.IOWriter;
import io.minio.spark.benchmarks.dfsio.Read$;
import io.minio.spark.benchmarks.dfsio.Stats;
import io.minio.spark.benchmarks.dfsio.StatsAccumulator$;
import io.minio.spark.benchmarks.dfsio.TestDFSIO;
import io.minio.spark.benchmarks.dfsio.TestDFSIOConf;
import io.minio.spark.benchmarks.dfsio.TestDFSIOConfParser$;
import io.minio.spark.benchmarks.dfsio.TestMode;
import io.minio.spark.benchmarks.dfsio.Write$;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.log4j.Level;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TestDFSIO$
implements App,
LazyLogging {
    public static final TestDFSIO$ MODULE$;
    private final String BaseFileName;
    private final String ControlDir;
    private final String DataDir;
    private final Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile boolean bitmap$0;

    static {
        new TestDFSIO$();
    }

    private Logger logger$lzycompute() {
        TestDFSIO$ testDFSIO$ = this;
        synchronized (testDFSIO$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public String BaseFileName() {
        return this.BaseFileName;
    }

    public String ControlDir() {
        return this.ControlDir;
    }

    public String DataDir() {
        return this.DataDir;
    }

    public void io$minio$spark$benchmarks$dfsio$TestDFSIO$$cleanUp(String benchmarkDir, Configuration hadoopConf) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Cleaning up test files");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Path path = new Path(benchmarkDir);
        FileSystem fs = path.getFileSystem(hadoopConf);
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }

    public void io$minio$spark$benchmarks$dfsio$TestDFSIO$$createControlFiles(String benchmarkDir, long fileSize, int numFiles, Configuration hadoopConf, SparkContext sc) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        Path controlDirPath = new Path(benchmarkDir, this.ControlDir());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Deleting any previous control directory...");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        FileSystem fs = controlDirPath.getFileSystem(hadoopConf);
        Object object = fs.exists(controlDirPath) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(controlDirPath, true)) : BoxedUnit.UNIT;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Creating control files: {} bytes, {} files", (Object[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToLong((long)fileSize)).toString(), ((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString()})).toArray(ClassTag$.MODULE$.apply(String.class)));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ControlFilesCreator$.MODULE$.createFiles(controlDirPath.toString(), numFiles, fileSize, sc);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Control files created for: {}  files", new Object[]{((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createControlFile(Configuration hadoopConf, Path controlDir, long fileSize, String fileName) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Path controlFilePath = new Path(controlDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in_file_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName})));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Creating control file in path {}, with size {} bytes", (Object[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{controlFilePath.toString(), ((Object)BoxesRunTime.boxToLong((long)fileSize)).toString()})).toArray(ClassTag$.MODULE$.apply(String.class)));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)hadoopConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)controlFilePath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(LongWritable.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
        try {
            writer.append((Writable)new Text(fileName), (Writable)new LongWritable(fileSize));
        }
        catch (Throwable throwable) {
            void var7_6;
            var7_6.close();
            throw throwable;
        }
        writer.close();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Control file created in path {}, with size {} bytes", (Object[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{controlFilePath.toString(), ((Object)BoxesRunTime.boxToLong((long)fileSize)).toString()})).toArray(ClassTag$.MODULE$.apply(String.class)));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Stats io$minio$spark$benchmarks$dfsio$TestDFSIO$$runWriteTest(String benchmarkDir, Configuration hadoopConf, SparkContext sc) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Path controlDirPath = new Path(benchmarkDir, this.ControlDir());
        Path dataDirPath = new Path(benchmarkDir, this.DataDir());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Deleting any previous data directories...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        FileSystem fs = dataDirPath.getFileSystem(hadoopConf);
        Object object = fs.exists(dataDirPath) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(dataDirPath, true)) : BoxedUnit.UNIT;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Writing files...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RDD files = sc.sequenceFile(controlDirPath.toString(), Text.class, LongWritable.class);
        RDD<Stats> stats = new IOWriter(hadoopConf, dataDirPath.toString()).runIOTest((RDD<Tuple2<Text, LongWritable>>)files);
        return StatsAccumulator$.MODULE$.accumulate(stats);
    }

    public Stats io$minio$spark$benchmarks$dfsio$TestDFSIO$$runReadTest(String benchmarkDir, Configuration hadoopConf, SparkContext sc) {
        BoxedUnit boxedUnit;
        Path controlDirPath = new Path(benchmarkDir, this.ControlDir());
        Path dataDirPath = new Path(benchmarkDir, this.DataDir());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Reading files...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RDD files = sc.sequenceFile(controlDirPath.toString(), Text.class, LongWritable.class);
        RDD<Stats> stats = new IOReader(hadoopConf, dataDirPath.toString()).runIOTest((RDD<Tuple2<Text, LongWritable>>)files);
        return StatsAccumulator$.MODULE$.accumulate(stats);
    }

    public void io$minio$spark$benchmarks$dfsio$TestDFSIO$$measure(TestMode testMode, String resFileName, Function0<Stats> job) {
        long startTime = System.currentTimeMillis();
        Stats stats = (Stats)job.apply();
        long execTime = System.currentTimeMillis() - startTime;
        this.analyzeResult(testMode, execTime, stats, resFileName);
    }

    private void analyzeResult(TestMode testMode, long execTime, Stats stats, String resFileName) {
        BoxedUnit boxedUnit;
        float med = stats.rate() / (float)1000 / (float)stats.tasks();
        double stdDev = package$.MODULE$.sqrt((double)package$.MODULE$.abs(stats.sqRate() / (float)1000 / (float)stats.tasks() - med * med));
        String resultLines = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |----- TestDFSIO ----- : ", "\n        |           Date & time: ", "\n        |       Number of files: ", "\n        |Total MBytes processed: ", "\n        |     Throughput mb/sec: ", "\n        |Average IO rate mb/sec: ", "\n        | IO rate std deviation: ", "\n        |    Test exec time sec: ", "\n        |\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testMode.command(), new Date(System.currentTimeMillis()), BoxesRunTime.boxToLong((long)stats.tasks()), BoxesRunTime.boxToLong((long)(stats.size() / 0x100000L)), BoxesRunTime.boxToDouble((double)((double)stats.size() * 1000.0 / (double)(stats.time() * 0x100000L))), BoxesRunTime.boxToFloat((float)med), BoxesRunTime.boxToDouble((double)stdDev), BoxesRunTime.boxToFloat((float)((float)execTime / (float)1000))})))).stripMargin();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(resultLines);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.appendToResultFile(resFileName, resultLines);
    }

    private String getFileName(int fileIndex) {
        return new StringBuilder().append((Object)this.BaseFileName()).append((Object)BoxesRunTime.boxToInteger((int)fileIndex)).toString();
    }

    private String getCompressionCodecClass(String codec) {
        return this.getCompressionCodec(codec).getName();
    }

    private Class<? extends CompressionCodec> getCompressionCodec(String codec) {
        String string;
        block6: {
            Class<GzipCodec> clazz;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            string = codec;
                            if (!"gzip".equals(string)) break block2;
                            clazz = GzipCodec.class;
                            break block3;
                        }
                        if (!"snappy".equals(string)) break block4;
                        clazz = SnappyCodec.class;
                        break block3;
                    }
                    if (!"lz4".equals(string)) break block5;
                    clazz = Lz4Codec.class;
                    break block3;
                }
                if (!"bzip2".equals(string)) break block6;
                clazz = BZip2Codec.class;
            }
            return clazz;
        }
        throw new MatchError((Object)string);
    }

    /*
     * WARNING - void declaration
     */
    private <A> A withPrintWriter(String name, boolean append, Function1<PrintWriter, A> func) {
        Object object;
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(name, append)));
        try {
            object = func.apply((Object)writer);
            writer.close();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        return (A)object;
    }

    private <A> boolean withPrintWriter$default$2() {
        return true;
    }

    private void appendToResultFile(String resFileName, String resultLines) {
        this.withPrintWriter(resFileName, this.withPrintWriter$default$2(), (Function1)new Serializable(resultLines){
            public static final long serialVersionUID = 0L;
            private final String resultLines$1;

            public final void apply(PrintWriter writer) {
                writer.println(this.resultLines$1);
            }
            {
                this.resultLines$1 = resultLines$1;
            }
        });
    }

    public final void delayedEndpoint$io$minio$spark$benchmarks$dfsio$TestDFSIO$1() {
        this.BaseFileName = "test_io_";
        this.ControlDir = "io_control";
        this.DataDir = "io_data";
        org.apache.log4j.Logger.getLogger((String)"akka").setLevel(Level.WARN);
        TestDFSIOConfParser$.MODULE$.parseAndRun((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.args()), (Function1<TestDFSIOConf, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(TestDFSIOConf conf) {
                SparkConf sparkConf = new SparkConf().setAppName("TestDFSIO").set("spark.logConf", "true");
                SparkContext sc = SparkContext$.MODULE$.getOrCreate(sparkConf);
                conf.hadoopExtraProps().foreach((Function1)new Serializable(this, sc){
                    public static final long serialVersionUID = 0L;
                    private final SparkContext sc$1;

                    public final void apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            this.sc$1.hadoopConfiguration().set(k, v);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.sc$1 = sc$1;
                    }
                });
                Configuration hadoopConf = new Configuration(sc.hadoopConfiguration());
                hadoopConf.setInt("test.io.file.buffer.size", conf.bufferSize());
                Serializable analyze = new Serializable(this, conf){
                    public static final long serialVersionUID = 0L;
                    private final TestDFSIOConf conf$1;

                    public final void apply(Function0<Stats> job) {
                        TestDFSIO$.MODULE$.io$minio$spark$benchmarks$dfsio$TestDFSIO$$measure(this.conf$1.mode(), this.conf$1.resFileName(), job);
                    }
                    {
                        this.conf$1 = conf$1;
                    }
                };
                TestMode testMode = conf.mode();
                if (Clean$.MODULE$.equals(testMode)) {
                    TestDFSIO$.MODULE$.io$minio$spark$benchmarks$dfsio$TestDFSIO$$cleanUp(conf.benchmarkDir(), hadoopConf);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (Write$.MODULE$.equals(testMode)) {
                    TestDFSIO$.MODULE$.io$minio$spark$benchmarks$dfsio$TestDFSIO$$createControlFiles(conf.benchmarkDir(), conf.fileSize(), conf.numFiles(), hadoopConf, sc);
                    BoxedUnit boxedUnit = (BoxedUnit)analyze.apply((Object)new Serializable(this, sc, hadoopConf, conf){
                        public static final long serialVersionUID = 0L;
                        private final SparkContext sc$1;
                        private final Configuration hadoopConf$1;
                        private final TestDFSIOConf conf$1;

                        public final Stats apply() {
                            return TestDFSIO$.MODULE$.io$minio$spark$benchmarks$dfsio$TestDFSIO$$runWriteTest(this.conf$1.benchmarkDir(), this.hadoopConf$1, this.sc$1);
                        }
                        {
                            this.sc$1 = sc$1;
                            this.hadoopConf$1 = hadoopConf$1;
                            this.conf$1 = conf$1;
                        }
                    });
                } else if (Read$.MODULE$.equals(testMode)) {
                    BoxedUnit boxedUnit = (BoxedUnit)analyze.apply((Object)new Serializable(this, sc, hadoopConf, conf){
                        public static final long serialVersionUID = 0L;
                        private final SparkContext sc$1;
                        private final Configuration hadoopConf$1;
                        private final TestDFSIOConf conf$1;

                        public final Stats apply() {
                            return TestDFSIO$.MODULE$.io$minio$spark$benchmarks$dfsio$TestDFSIO$$runReadTest(this.conf$1.benchmarkDir(), this.hadoopConf$1, this.sc$1);
                        }
                        {
                            this.sc$1 = sc$1;
                            this.hadoopConf$1 = hadoopConf$1;
                            this.conf$1 = conf$1;
                        }
                    });
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    private TestDFSIO$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new TestDFSIO.delayedInit.body(this));
    }
}

