/*
 * Decompiled with CFR 0.152.
 */
package io.minio.http;

import com.squareup.okhttp.Headers;
import io.minio.http.Header;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeaderParser {
    private static final Logger LOGGER = Logger.getLogger(HeaderParser.class.getName());

    private HeaderParser() {
    }

    public static void set(Headers headers, Object destination) {
        Class<?> cls = destination.getClass();
        Field[] publicFields = cls.getFields();
        Field[] privateFields = cls.getDeclaredFields();
        Field[] fields = new Field[publicFields.length + privateFields.length];
        System.arraycopy(publicFields, 0, fields, 0, publicFields.length);
        System.arraycopy(privateFields, 0, fields, publicFields.length, privateFields.length);
        for (Field field : fields) {
            Header annotation = field.getAnnotation(Header.class);
            if (annotation == null) continue;
            Header httpHeader = annotation;
            String value = httpHeader.value();
            String setter = httpHeader.setter();
            if (setter.isEmpty()) {
                String name = field.getName();
                setter = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            try {
                Method setterMethod = cls.getMethod(setter, String.class);
                String valueString = headers.get(value);
                if (valueString == null) continue;
                setterMethod.invoke(destination, valueString);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "exception occured: ", e);
                LOGGER.log(Level.INFO, "setter: " + setter);
                LOGGER.log(Level.INFO, "annotation: " + value);
                LOGGER.log(Level.INFO, "value: " + headers.get(value));
            }
        }
    }
}

