/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.io.ByteStreams;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import io.minio.AwsS3Endpoints;
import io.minio.BucketRegionCache;
import io.minio.DateFormat;
import io.minio.Digest;
import io.minio.ErrorCode;
import io.minio.HttpResponse;
import io.minio.MinioProperties;
import io.minio.ObjectStat;
import io.minio.PostPolicy;
import io.minio.ResponseHeader;
import io.minio.Result;
import io.minio.S3Escaper;
import io.minio.Signer;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidArgumentException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidExpiresRangeException;
import io.minio.errors.InvalidObjectPrefixException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.NoResponseException;
import io.minio.http.HeaderParser;
import io.minio.http.Method;
import io.minio.http.Scheme;
import io.minio.messages.Bucket;
import io.minio.messages.CompleteMultipartUpload;
import io.minio.messages.CreateBucketConfiguration;
import io.minio.messages.ErrorResponse;
import io.minio.messages.InitiateMultipartUploadResult;
import io.minio.messages.Item;
import io.minio.messages.ListAllMyBucketsResult;
import io.minio.messages.ListBucketResult;
import io.minio.messages.ListMultipartUploadsResult;
import io.minio.messages.ListPartsResult;
import io.minio.messages.Part;
import io.minio.messages.Prefix;
import io.minio.messages.Upload;
import io.minio.org.apache.commons.validator.routines.InetAddressValidator;
import io.minio.policy.BucketPolicy;
import io.minio.policy.PolicyType;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.BufferedSink;
import okio.Okio;
import org.joda.time.DateTime;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class MinioClient {
    private static final Logger LOGGER = Logger.getLogger(MinioClient.class.getName());
    private static final long MAX_OBJECT_SIZE = 0x50000000000L;
    private static final int MAX_MULTIPART_COUNT = 10000;
    private static final int MIN_MULTIPART_SIZE = 0x500000;
    private static final int DEFAULT_EXPIRY_TIME = 604800;
    private static final String DEFAULT_USER_AGENT = "Minio (" + System.getProperty("os.arch") + "; " + System.getProperty("os.arch") + ") minio-java/" + MinioProperties.INSTANCE.getVersion();
    private static final String NULL_STRING = "(null)";
    private static final String S3_AMAZONAWS_COM = "s3.amazonaws.com";
    private static final String AMAZONAWS_COM = ".amazonaws.com";
    private static final String END_HTTP = "----------END-HTTP----------";
    private static final String US_EAST_1 = "us-east-1";
    private static final String UPLOAD_ID = "uploadId";
    private static XmlPullParserFactory xmlPullParserFactory = null;
    private PrintWriter traceStream;
    private HttpUrl baseUrl;
    private String accessKey;
    private String secretKey;
    private String userAgent = DEFAULT_USER_AGENT;
    private OkHttpClient httpClient = new OkHttpClient();

    public MinioClient(String endpoint) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, null, null);
    }

    public MinioClient(URL url) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, null, null);
    }

    public MinioClient(HttpUrl url) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, null, null);
    }

    public MinioClient(String endpoint, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey);
    }

    public MinioClient(URL url, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, accessKey, secretKey);
    }

    public MinioClient(HttpUrl url, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, accessKey, secretKey);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, port, accessKey, secretKey, endpoint == null || !endpoint.startsWith("http://"));
    }

    public MinioClient(String endpoint, String accessKey, String secretKey, boolean secure) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey, secure);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey, boolean secure) throws InvalidEndpointException, InvalidPortException {
        if (endpoint == null) {
            throw new InvalidEndpointException(NULL_STRING, "null endpoint");
        }
        if (port < 0 || port > 65535) {
            throw new InvalidPortException(port, "port must be in range of 1 to 65535");
        }
        HttpUrl url = HttpUrl.parse((String)endpoint);
        if (url != null) {
            if (!"/".equals(url.encodedPath())) {
                throw new InvalidEndpointException(endpoint, "no path allowed in endpoint");
            }
            String amzHost = url.host();
            if (amzHost.endsWith(AMAZONAWS_COM) && !amzHost.equals(S3_AMAZONAWS_COM)) {
                throw new InvalidEndpointException(endpoint, "for Amazon S3, host should be 's3.amazonaws.com' in endpoint");
            }
            HttpUrl.Builder urlBuilder = url.newBuilder();
            Scheme scheme = Scheme.HTTP;
            if (secure) {
                scheme = Scheme.HTTPS;
            }
            urlBuilder.scheme(scheme.toString());
            if (port > 0) {
                urlBuilder.port(port);
            }
            this.baseUrl = urlBuilder.build();
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            return;
        }
        if (!this.isValidEndpoint(endpoint)) {
            throw new InvalidEndpointException(endpoint, "invalid host");
        }
        if (endpoint.endsWith(AMAZONAWS_COM) && !endpoint.equals(S3_AMAZONAWS_COM)) {
            throw new InvalidEndpointException(endpoint, "for amazon S3, host should be 's3.amazonaws.com'");
        }
        Scheme scheme = Scheme.HTTP;
        if (secure) {
            scheme = Scheme.HTTPS;
        }
        this.baseUrl = port == 0 ? new HttpUrl.Builder().scheme(scheme.toString()).host(endpoint).build() : new HttpUrl.Builder().scheme(scheme.toString()).host(endpoint).port(port).build();
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    private boolean isValidEndpoint(String endpoint) {
        if (InetAddressValidator.getInstance().isValid(endpoint)) {
            return true;
        }
        if (endpoint.length() < 1 || endpoint.length() > 253) {
            return false;
        }
        for (String label : endpoint.split("\\.")) {
            if (label.length() < 1 || label.length() > 63) {
                return false;
            }
            if (label.matches("^[a-zA-Z0-9][a-zA-Z0-9-]*") && endpoint.matches(".*[a-zA-Z0-9]$")) continue;
            return false;
        }
        return true;
    }

    private void checkObjectPrefix(String prefix) throws InvalidObjectPrefixException {
        if (prefix.length() > 1024) {
            throw new InvalidObjectPrefixException(prefix, "Object prefix cannot be greater than 1024 characters.");
        }
        try {
            prefix.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            throw new InvalidObjectPrefixException(prefix, "Object prefix cannot be properly encoded to utf-8.");
        }
    }

    private void checkBucketName(String name) throws InvalidBucketNameException {
        if (name == null) {
            throw new InvalidBucketNameException(NULL_STRING, "null bucket name");
        }
        if (name.length() < 3 || name.length() > 63) {
            String msg = "bucket name must be at least 3 and no more than 63 characters long";
            throw new InvalidBucketNameException(name, msg);
        }
        if (name.matches("\\.\\.")) {
            String msg = "bucket name cannot contain successive periods. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
        if (!name.matches("^[a-z0-9][a-z0-9\\.\\-]+[a-z0-9]$")) {
            String msg = "bucket name does not follow Amazon S3 standards. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
    }

    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.httpClient.setConnectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        this.httpClient.setWriteTimeout(writeTimeout, TimeUnit.MILLISECONDS);
        this.httpClient.setReadTimeout(readTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private Request createRequest(Method method, String bucketName, String objectName, String region, Map<String, String> headerMap, Map<String, String> queryParamMap, final String contentType, final Object body, final int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException {
        void var12_20;
        if (bucketName == null && objectName != null) {
            throw new InvalidBucketNameException(NULL_STRING, "null bucket name for object '" + objectName + "'");
        }
        HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder();
        if (bucketName != null) {
            this.checkBucketName(bucketName);
            Object host = this.baseUrl.host();
            if (((String)host).equals(S3_AMAZONAWS_COM)) {
                void var12_16;
                if (region != null) {
                    host = AwsS3Endpoints.INSTANCE.endpoint(region);
                }
                boolean bl = false;
                if (method == Method.PUT && objectName == null && queryParamMap == null) {
                    boolean bl2 = true;
                } else if (queryParamMap != null && queryParamMap.containsKey("location")) {
                    boolean bl3 = true;
                } else if (bucketName.contains(".") && this.baseUrl.isHttps()) {
                    boolean bl4 = true;
                }
                if (var12_16 != false) {
                    urlBuilder.host((String)host);
                    urlBuilder.addEncodedPathSegment(S3Escaper.encode(bucketName));
                } else {
                    urlBuilder.host(bucketName + "." + (String)host);
                }
            } else {
                urlBuilder.addEncodedPathSegment(S3Escaper.encode(bucketName));
            }
        }
        if (objectName != null) {
            urlBuilder.addEncodedPathSegment(S3Escaper.encodePath(objectName));
        }
        if (queryParamMap != null) {
            for (Map.Entry entry : queryParamMap.entrySet()) {
                urlBuilder.addEncodedQueryParameter(S3Escaper.encode((String)entry.getKey()), S3Escaper.encode((String)entry.getValue()));
            }
        }
        HttpUrl url = urlBuilder.build();
        Object var12_18 = null;
        if (body != null) {
            RequestBody requestBody = new RequestBody(){

                public MediaType contentType() {
                    if (contentType != null) {
                        return MediaType.parse((String)contentType);
                    }
                    return MediaType.parse((String)"application/octet-stream");
                }

                public long contentLength() {
                    if (body instanceof InputStream || body instanceof RandomAccessFile || body instanceof byte[]) {
                        return length;
                    }
                    if (length == 0) {
                        return -1L;
                    }
                    return length;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    if (body instanceof InputStream) {
                        InputStream stream = (InputStream)body;
                        sink.write(Okio.source((InputStream)stream), (long)length);
                    } else if (body instanceof RandomAccessFile) {
                        RandomAccessFile file = (RandomAccessFile)body;
                        sink.write(Okio.source((InputStream)Channels.newInputStream(file.getChannel())), (long)length);
                    } else if (body instanceof byte[]) {
                        byte[] data = (byte[])body;
                        sink.write(data, 0, length);
                    } else {
                        sink.writeUtf8(body.toString());
                    }
                }
            };
        }
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        requestBuilder.method(method.toString(), (RequestBody)var12_20);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                requestBuilder.header(entry.getKey(), entry.getValue());
            }
        }
        String sha256Hash = null;
        String md5Hash = null;
        if (this.accessKey != null && this.secretKey != null) {
            String[] hashes;
            byte[] data;
            if (url.isHttps()) {
                sha256Hash = "UNSIGNED-PAYLOAD";
                if (body instanceof BufferedInputStream) {
                    md5Hash = Digest.md5Hash((BufferedInputStream)body, length);
                } else if (body instanceof RandomAccessFile) {
                    md5Hash = Digest.md5Hash((RandomAccessFile)body, length);
                } else if (body instanceof byte[]) {
                    data = (byte[])body;
                    md5Hash = Digest.md5Hash(data, length);
                }
            } else if (body == null) {
                sha256Hash = Digest.sha256Hash(new byte[0]);
            } else if (body instanceof BufferedInputStream) {
                hashes = Digest.sha256md5Hashes((BufferedInputStream)body, length);
                sha256Hash = hashes[0];
                md5Hash = hashes[1];
            } else if (body instanceof RandomAccessFile) {
                hashes = Digest.sha256md5Hashes((RandomAccessFile)body, length);
                sha256Hash = hashes[0];
                md5Hash = hashes[1];
            } else if (body instanceof byte[]) {
                data = (byte[])body;
                sha256Hash = Digest.sha256Hash(data, length);
                md5Hash = Digest.md5Hash(data, length);
            } else {
                sha256Hash = Digest.sha256Hash(body.toString());
            }
        }
        if (md5Hash != null) {
            requestBuilder.header("Content-MD5", md5Hash);
        }
        if (url.port() == 80 || url.port() == 443) {
            requestBuilder.header("Host", url.host());
        } else {
            requestBuilder.header("Host", url.host() + ":" + url.port());
        }
        requestBuilder.header("User-Agent", this.userAgent);
        if (sha256Hash != null) {
            requestBuilder.header("x-amz-content-sha256", sha256Hash);
        }
        DateTime date = new DateTime();
        requestBuilder.header("x-amz-date", date.toString(DateFormat.AMZ_DATE_FORMAT));
        return requestBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse execute(Method method, String region, String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, String contentType, Object body, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        Response response;
        Request request = this.createRequest(method, bucketName, objectName, region, headerMap, queryParamMap, contentType, body, length);
        if (this.accessKey != null && this.secretKey != null) {
            request = Signer.signV4(request, region, this.accessKey, this.secretKey);
        }
        if (this.traceStream != null) {
            this.traceStream.println("---------START-HTTP---------");
            String encodedPath = request.httpUrl().encodedPath();
            String encodedQuery = request.httpUrl().encodedQuery();
            if (encodedQuery != null) {
                encodedPath = encodedPath + "?" + encodedQuery;
            }
            this.traceStream.println(request.method() + " " + encodedPath + " HTTP/1.1");
            String headers = request.headers().toString().replaceAll("Signature=([0-9a-f]+)", "Signature=*REDACTED*");
            this.traceStream.println(headers);
        }
        if ((response = this.httpClient.newCall(request).execute()) == null) {
            if (this.traceStream != null) {
                this.traceStream.println("<NO RESPONSE>");
                this.traceStream.println(END_HTTP);
            }
            throw new NoResponseException();
        }
        if (this.traceStream != null) {
            this.traceStream.println(response.protocol().toString().toUpperCase() + " " + response.code());
            this.traceStream.println(response.headers());
        }
        ResponseHeader header = new ResponseHeader();
        HeaderParser.set(response.headers(), header);
        if (response.isSuccessful()) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            return new HttpResponse(header, response);
        }
        ErrorResponse errorResponse = null;
        if (!method.equals((Object)Method.HEAD)) {
            try {
                String errorXml = "";
                Scanner scanner = new Scanner(response.body().charStream()).useDelimiter("\\A");
                if (scanner.hasNext()) {
                    errorXml = scanner.next();
                }
                errorResponse = new ErrorResponse(new StringReader(errorXml));
                if (this.traceStream != null) {
                    this.traceStream.println(errorXml);
                }
            }
            finally {
                response.body().close();
            }
        }
        if (this.traceStream != null) {
            this.traceStream.println(END_HTTP);
        }
        if (errorResponse == null) {
            ErrorCode ec;
            switch (response.code()) {
                case 400: {
                    ec = ErrorCode.INVALID_URI;
                    break;
                }
                case 404: {
                    if (objectName != null) {
                        ec = ErrorCode.NO_SUCH_KEY;
                        break;
                    }
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_NOT_FOUND;
                    break;
                }
                case 405: 
                case 501: {
                    ec = ErrorCode.METHOD_NOT_ALLOWED;
                    break;
                }
                case 409: {
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_CONFLICT;
                    break;
                }
                case 403: {
                    ec = ErrorCode.ACCESS_DENIED;
                    break;
                }
                default: {
                    throw new InternalException("unhandled HTTP code " + response.code() + ".  Please report this issue at https://github.com/minio/minio-java/issues");
                }
            }
            errorResponse = new ErrorResponse(ec, bucketName, objectName, request.httpUrl().encodedPath(), header.xamzRequestId(), header.xamzId2());
        }
        if (errorResponse.errorCode() == ErrorCode.NO_SUCH_BUCKET) {
            BucketRegionCache.INSTANCE.remove(bucketName);
        }
        throw new ErrorResponseException(errorResponse, response);
    }

    private void updateRegionCache(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        if (bucketName != null && S3_AMAZONAWS_COM.equals(this.baseUrl.host()) && this.accessKey != null && this.secretKey != null && !BucketRegionCache.INSTANCE.exists(bucketName)) {
            HashMap<String, String> queryParamMap = new HashMap<String, String>();
            queryParamMap.put("location", null);
            HttpResponse response = this.execute(Method.GET, US_EAST_1, bucketName, null, null, queryParamMap, null, null, 0);
            XmlPullParser xpp = xmlPullParserFactory.newPullParser();
            String location = null;
            xpp.setInput(response.body().charStream());
            while (true) {
                if (xpp.getEventType() == 1) break;
                if (xpp.getEventType() == 2 && xpp.getName() == "LocationConstraint") {
                    xpp.next();
                    location = this.getText(xpp, location);
                    break;
                }
                xpp.next();
            }
            response.body().close();
            String region = location == null ? US_EAST_1 : ("EU".equals(location) ? "eu-west-1" : location);
            BucketRegionCache.INSTANCE.add(bucketName, region);
        }
    }

    private String getText(XmlPullParser xpp, String location) throws XmlPullParserException {
        if (xpp.getEventType() == 4) {
            return xpp.getText();
        }
        return location;
    }

    private HttpResponse executeGet(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.updateRegionCache(bucketName);
        return this.execute(Method.GET, BucketRegionCache.INSTANCE.region(bucketName), bucketName, objectName, headerMap, queryParamMap, null, null, 0);
    }

    private HttpResponse executeHead(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.updateRegionCache(bucketName);
        HttpResponse response = this.execute(Method.HEAD, BucketRegionCache.INSTANCE.region(bucketName), bucketName, objectName, null, null, null, null, 0);
        response.body().close();
        return response;
    }

    private HttpResponse executeDelete(String bucketName, String objectName, Map<String, String> queryParamMap) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.updateRegionCache(bucketName);
        HttpResponse response = this.execute(Method.DELETE, BucketRegionCache.INSTANCE.region(bucketName), bucketName, objectName, null, queryParamMap, null, null, 0);
        response.body().close();
        return response;
    }

    private HttpResponse executePost(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, Object data) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.updateRegionCache(bucketName);
        return this.execute(Method.POST, BucketRegionCache.INSTANCE.region(bucketName), bucketName, objectName, headerMap, queryParamMap, null, data, 0);
    }

    private HttpResponse executePut(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, String region, Object data, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HttpResponse response = this.execute(Method.PUT, region, bucketName, objectName, headerMap, queryParamMap, "", data, length);
        response.body().close();
        return response;
    }

    private HttpResponse executePut(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, Object data, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.updateRegionCache(bucketName);
        return this.executePut(bucketName, objectName, headerMap, queryParamMap, BucketRegionCache.INSTANCE.region(bucketName), data, length);
    }

    public void setAppInfo(String name, String version) {
        if (name == null || version == null) {
            return;
        }
        this.userAgent = DEFAULT_USER_AGENT + " " + name.trim() + "/" + version.trim();
    }

    public ObjectStat statObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HttpResponse response = this.executeHead(bucketName, objectName);
        ResponseHeader header = response.header();
        return new ObjectStat(bucketName, objectName, header.lastModified(), header.contentLength(), header.etag(), header.contentType());
    }

    public InputStream getObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException {
        return this.getObject(bucketName, objectName, 0L, null);
    }

    public InputStream getObject(String bucketName, String objectName, long offset) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException {
        return this.getObject(bucketName, objectName, offset, null);
    }

    public InputStream getObject(String bucketName, String objectName, long offset, Long length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException {
        if (offset < 0L) {
            throw new InvalidArgumentException("offset should be zero or greater");
        }
        if (length != null && length <= 0L) {
            throw new InvalidArgumentException("length should be greater than zero");
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (length != null) {
            headerMap.put("Range", "bytes=" + offset + "-" + (offset + length - 1L));
        } else {
            headerMap.put("Range", "bytes=" + offset + "-");
        }
        HttpResponse response = this.executeGet(bucketName, objectName, headerMap, null);
        return response.body().byteStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getObject(String bucketName, String objectName, String fileName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException {
        Path filePath = Paths.get(fileName, new String[0]);
        boolean fileExists = Files.exists(filePath, new LinkOption[0]);
        if (fileExists && !Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new InvalidArgumentException(fileName + ": not a regular file");
        }
        ObjectStat objectStat = this.statObject(bucketName, objectName);
        long length = objectStat.length();
        String etag = objectStat.etag();
        String tempFileName = fileName + "." + etag + ".part.minio";
        Path tempFilePath = Paths.get(tempFileName, new String[0]);
        boolean tempFileExists = Files.exists(tempFilePath, new LinkOption[0]);
        if (tempFileExists && !Files.isRegularFile(tempFilePath, new LinkOption[0])) {
            throw new IOException(tempFileName + ": not a regular file");
        }
        long tempFileSize = 0L;
        if (tempFileExists && (tempFileSize = Files.size(tempFilePath)) > length) {
            Files.delete(tempFilePath);
            tempFileExists = false;
            tempFileSize = 0L;
        }
        if (fileExists) {
            long fileSize = Files.size(filePath);
            if (fileSize == length) {
                return;
            }
            if (fileSize > length) {
                throw new InvalidArgumentException("'" + fileName + "': object size " + length + " is smaller than file size " + fileSize);
            }
            if (!tempFileExists) {
                Files.copy(filePath, tempFilePath, new CopyOption[0]);
                tempFileSize = fileSize;
                tempFileExists = true;
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getObject(bucketName, objectName, tempFileSize);
            os = Files.newOutputStream(tempFilePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            long bytesWritten = ByteStreams.copy((InputStream)is, (OutputStream)os);
            is.close();
            os.close();
            if (bytesWritten != length - tempFileSize) {
                throw new IOException(tempFileName + ": unexpected data written.  expected = " + (length - tempFileSize) + ", written = " + bytesWritten);
            }
            Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public String presignedGetObject(String bucketName, String objectName, Integer expires, Map<String, String> reqParams) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException {
        if (expires < 1 || expires > 604800) {
            throw new InvalidExpiresRangeException(expires, "expires must be in range of 1 to 604800");
        }
        this.updateRegionCache(bucketName);
        String region = BucketRegionCache.INSTANCE.region(bucketName);
        Request request = this.createRequest(Method.GET, bucketName, objectName, region, null, reqParams, null, null, 0);
        HttpUrl url = Signer.presignV4(request, region, this.accessKey, this.secretKey, expires);
        return url.toString();
    }

    public String presignedGetObject(String bucketName, String objectName, Integer expires) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException {
        return this.presignedGetObject(bucketName, objectName, expires, null);
    }

    public String presignedGetObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException {
        return this.presignedGetObject(bucketName, objectName, 604800, null);
    }

    public String presignedPutObject(String bucketName, String objectName, Integer expires) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException {
        if (expires < 1 || expires > 604800) {
            throw new InvalidExpiresRangeException(expires, "expires must be in range of 1 to 604800");
        }
        this.updateRegionCache(bucketName);
        String region = BucketRegionCache.INSTANCE.region(bucketName);
        Request request = this.createRequest(Method.PUT, bucketName, objectName, region, null, null, null, "", 0);
        HttpUrl url = Signer.presignV4(request, region, this.accessKey, this.secretKey, expires);
        return url.toString();
    }

    public String presignedPutObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException {
        return this.presignedPutObject(bucketName, objectName, 604800);
    }

    public Map<String, String> presignedPostPolicy(PostPolicy policy) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.updateRegionCache(policy.bucketName());
        return policy.formData(this.accessKey, this.secretKey);
    }

    public void removeObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.executeDelete(bucketName, objectName, null);
    }

    public Iterable<Result<Item>> listObjects(String bucketName) throws XmlPullParserException {
        return this.listObjects(bucketName, null);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix) throws XmlPullParserException {
        return this.listObjects(bucketName, prefix, true);
    }

    public Iterable<Result<Item>> listObjects(final String bucketName, final String prefix, final boolean recursive) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new Iterator<Result<Item>>(){
                    private String lastObjectName;
                    private ListBucketResult listBucketResult;
                    private Result<Item> error;
                    private Iterator<Item> itemIterator;
                    private Iterator<Prefix> prefixIterator;
                    private boolean completed = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        String marker = null;
                        if (this.listBucketResult != null) {
                            marker = delimiter != null ? this.listBucketResult.nextMarker() : this.lastObjectName;
                        }
                        this.listBucketResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        try {
                            this.listBucketResult = MinioClient.this.listObjects(bucketName, marker, prefix, delimiter, null);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            if (this.listBucketResult != null) {
                                this.itemIterator = this.listBucketResult.contents().iterator();
                                this.prefixIterator = this.listBucketResult.commonPrefixes().iterator();
                            } else {
                                this.itemIterator = new LinkedList().iterator();
                                this.prefixIterator = new LinkedList().iterator();
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.itemIterator.hasNext()) {
                            return true;
                        }
                        if (this.prefixIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Item> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.itemIterator.hasNext()) {
                            Item item = this.itemIterator.next();
                            this.lastObjectName = item.objectName();
                            return new Result<Item>(item, null);
                        }
                        if (this.prefixIterator.hasNext()) {
                            Item item;
                            Prefix prefix = this.prefixIterator.next();
                            try {
                                item = new Item(prefix.prefix(), true);
                            }
                            catch (XmlPullParserException e) {
                                item = null;
                            }
                            return new Result<Item>(item, null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ListBucketResult listObjects(String bucketName, String marker, String prefix, String delimiter, Integer maxKeys) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        if (marker != null) {
            queryParamMap.put("marker", marker);
        }
        if (prefix != null) {
            queryParamMap.put("prefix", prefix);
        }
        if (delimiter != null) {
            queryParamMap.put("delimiter", delimiter);
        }
        if (maxKeys != null) {
            queryParamMap.put("max-keys", maxKeys.toString());
        }
        HttpResponse response = this.executeGet(bucketName, null, null, queryParamMap);
        ListBucketResult result = new ListBucketResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result;
    }

    public List<Bucket> listBuckets() throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HttpResponse response = this.executeGet(null, null, null, null);
        ListAllMyBucketsResult result = new ListAllMyBucketsResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result.buckets();
    }

    public boolean bucketExists(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        try {
            this.executeHead(bucketName, null);
            return true;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_BUCKET) {
                throw e;
            }
            return false;
        }
    }

    public void makeBucket(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.makeBucket(bucketName, null);
    }

    public void makeBucket(String bucketName, String region) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        String configString;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (region == null || US_EAST_1.equals(region)) {
            configString = "";
        } else {
            CreateBucketConfiguration config = new CreateBucketConfiguration(region);
            configString = config.toString();
        }
        this.executePut(bucketName, null, headerMap, null, US_EAST_1, configString, 0);
    }

    public void removeBucket(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.executeDelete(bucketName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(String bucketName, String objectName, String fileName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException {
        if (fileName == null || "".equals(fileName)) {
            throw new InvalidArgumentException("empty file name is not allowed");
        }
        Path filePath = Paths.get(fileName, new String[0]);
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new InvalidArgumentException("'" + fileName + "': not a regular file");
        }
        String contentType = Files.probeContentType(filePath);
        long size = Files.size(filePath);
        try (RandomAccessFile file = new RandomAccessFile(filePath.toFile(), "r");){
            this.putObject(bucketName, objectName, contentType, size, file);
        }
    }

    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException {
        this.putObject(bucketName, objectName, contentType, size, new BufferedInputStream(stream));
    }

    private String putObject(String bucketName, String objectName, int length, Object data, String uploadId, String contentType, int partNumber) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HashMap<String, String> queryParamMap = null;
        if (partNumber > 0 && uploadId != null && !"".equals(uploadId)) {
            queryParamMap = new HashMap<String, String>();
            queryParamMap.put("partNumber", Integer.toString(partNumber));
            queryParamMap.put(UPLOAD_ID, uploadId);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (contentType != null) {
            headerMap.put("Content-Type", contentType);
        } else {
            headerMap.put("Content-Type", "application/octet-stream");
        }
        HttpResponse response = this.executePut(bucketName, objectName, headerMap, queryParamMap, data, length);
        return response.header().etag();
    }

    private void putObject(String bucketName, String objectName, String contentType, long size, Object data) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException {
        if (size <= 0x500000L) {
            this.putObject(bucketName, objectName, (int)size, data, null, contentType, 0);
            return;
        }
        int[] rv = MinioClient.calculateMultipartSize(size);
        int partSize = rv[0];
        int partCount = rv[1];
        int lastPartSize = rv[2];
        Part[] totalParts = new Part[partCount];
        String uploadId = this.getLatestIncompleteUploadId(bucketName, objectName);
        Iterator<Result<Part>> existingParts = null;
        Part part = null;
        if (uploadId != null) {
            existingParts = this.listObjectParts(bucketName, objectName, uploadId).iterator();
            if (existingParts.hasNext()) {
                part = existingParts.next().get();
            }
        } else {
            uploadId = this.initMultipartUpload(bucketName, objectName, contentType);
        }
        int expectedReadSize = partSize;
        for (int partNumber = 1; partNumber <= partCount; ++partNumber) {
            String md5Hash;
            if (partNumber == partCount) {
                expectedReadSize = lastPartSize;
            }
            if (part != null && partNumber == part.partNumber() && (long)expectedReadSize == part.partSize() && (md5Hash = Digest.md5Hash(data, expectedReadSize)).equals(part.etag())) {
                totalParts[partNumber - 1] = new Part(part.partNumber(), part.etag());
                this.skipStream(data, expectedReadSize);
                part = this.getPart(existingParts);
                continue;
            }
            String etag = this.putObject(bucketName, objectName, expectedReadSize, data, uploadId, null, partNumber);
            totalParts[partNumber - 1] = new Part(partNumber, etag);
        }
        this.completeMultipart(bucketName, objectName, uploadId, totalParts);
    }

    private BucketPolicy getBucketPolicy(String bucketName) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        BucketPolicy policy;
        block3: {
            HashMap<String, String> queryParamMap = new HashMap<String, String>();
            queryParamMap.put("policy", "");
            policy = null;
            HttpResponse response = null;
            try {
                response = this.executeGet(bucketName, null, null, queryParamMap);
                policy = BucketPolicy.parseJson(response.body().charStream(), bucketName);
                response.body().close();
            }
            catch (ErrorResponseException e) {
                if (e.errorResponse().errorCode() == ErrorCode.NO_SUCH_BUCKET_POLICY) break block3;
                throw e;
            }
        }
        if (policy == null) {
            policy = new BucketPolicy(bucketName);
        }
        return policy;
    }

    public PolicyType getBucketPolicy(String bucketName, String objectPrefix) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.checkObjectPrefix(objectPrefix);
        BucketPolicy policy = this.getBucketPolicy(bucketName);
        return policy.getPolicy(objectPrefix);
    }

    private void setBucketPolicy(String bucketName, BucketPolicy policy) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("policy", "");
        String policyJson = policy.getJson();
        HttpResponse response = this.executePut(bucketName, "", null, queryParamMap, policyJson, policyJson.length());
        response.body().close();
    }

    public void setBucketPolicy(String bucketName, String objectPrefix, PolicyType policyType) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        this.checkObjectPrefix(objectPrefix);
        BucketPolicy policy = this.getBucketPolicy(bucketName);
        if (policyType == PolicyType.NONE && policy.statements() == null) {
            return;
        }
        policy.setPolicy(policyType, objectPrefix);
        this.setBucketPolicy(bucketName, policy);
    }

    private Part getPart(Iterator<Result<Part>> existingParts) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        Part part = null;
        if (existingParts.hasNext()) {
            part = existingParts.next().get();
        }
        return part;
    }

    private String getLatestIncompleteUploadId(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        Upload latestUpload = null;
        for (Result<Upload> result : this.listIncompleteUploads(bucketName, objectName, true, false)) {
            Upload upload = result.get();
            if (!upload.objectName().equals(objectName) || latestUpload != null && latestUpload.initiated().compareTo(upload.initiated()) >= 0) continue;
            latestUpload = upload;
        }
        if (latestUpload != null) {
            return latestUpload.uploadId();
        }
        return null;
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName) throws XmlPullParserException {
        return this.listIncompleteUploads(bucketName, null, true, true);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix) throws XmlPullParserException {
        return this.listIncompleteUploads(bucketName, prefix, true, true);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix, boolean recursive) {
        return this.listIncompleteUploads(bucketName, prefix, recursive, true);
    }

    private Iterable<Result<Upload>> listIncompleteUploads(final String bucketName, final String prefix, final boolean recursive, final boolean aggregatePartSize) {
        return new Iterable<Result<Upload>>(){

            @Override
            public Iterator<Result<Upload>> iterator() {
                return new Iterator<Result<Upload>>(){
                    private String nextKeyMarker;
                    private String nextUploadIdMarker;
                    private ListMultipartUploadsResult listMultipartUploadsResult;
                    private Result<Upload> error;
                    private Iterator<Upload> uploadIterator;
                    private boolean completed = false;

                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        this.listMultipartUploadsResult = null;
                        this.uploadIterator = null;
                        try {
                            this.listMultipartUploadsResult = MinioClient.this.listIncompleteUploads(bucketName, this.nextKeyMarker, this.nextUploadIdMarker, prefix, delimiter, 1000);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            this.uploadIterator = this.listMultipartUploadsResult != null ? this.listMultipartUploadsResult.uploads().iterator() : new LinkedList().iterator();
                        }
                    }

                    private synchronized long getAggregatedPartSize(String objectName, String uploadId) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
                        long aggregatedPartSize = 0L;
                        for (Result result : MinioClient.this.listObjectParts(bucketName, objectName, uploadId)) {
                            aggregatedPartSize += ((Part)((Object)result.get())).partSize();
                        }
                        return aggregatedPartSize;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.uploadIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Upload> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.uploadIterator.hasNext()) {
                            Upload upload = this.uploadIterator.next();
                            if (aggregatePartSize) {
                                long aggregatedPartSize;
                                try {
                                    aggregatedPartSize = this.getAggregatedPartSize(upload.objectName(), upload.uploadId());
                                }
                                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                                    aggregatedPartSize = -1L;
                                }
                                upload.setAggregatedPartSize(aggregatedPartSize);
                            }
                            return new Result<Upload>(upload, null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ListMultipartUploadsResult listIncompleteUploads(String bucketName, String keyMarker, String uploadIdMarker, String prefix, String delimiter, int maxUploads) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        if (maxUploads < 0 || maxUploads > 1000) {
            maxUploads = 1000;
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("uploads", "");
        queryParamMap.put("max-uploads", Integer.toString(maxUploads));
        queryParamMap.put("prefix", prefix);
        queryParamMap.put("key-marker", keyMarker);
        queryParamMap.put("upload-id-marker", uploadIdMarker);
        queryParamMap.put("delimiter", delimiter);
        HttpResponse response = this.executeGet(bucketName, null, null, queryParamMap);
        ListMultipartUploadsResult result = new ListMultipartUploadsResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result;
    }

    private String initMultipartUpload(String bucketName, String objectName, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (contentType != null) {
            headerMap.put("Content-Type", contentType);
        } else {
            headerMap.put("Content-Type", "application/octet-stream");
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("uploads", "");
        HttpResponse response = this.executePost(bucketName, objectName, headerMap, queryParamMap, "");
        InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result.uploadId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeMultipart(String bucketName, String objectName, String uploadId, Part[] parts) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        ErrorResponse errorResponse;
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        CompleteMultipartUpload completeManifest = new CompleteMultipartUpload(parts);
        HttpResponse response = this.executePost(bucketName, objectName, null, queryParamMap, (Object)completeManifest);
        String bodyContent = "";
        try {
            Scanner scanner = new Scanner(response.body().charStream()).useDelimiter("\\A");
            if (scanner.hasNext()) {
                bodyContent = scanner.next();
            }
        }
        catch (EOFException e) {
            LOGGER.log(Level.WARNING, "EOF exception occured: " + e);
        }
        finally {
            response.body().close();
        }
        bodyContent = bodyContent.trim();
        if (!bodyContent.isEmpty() && (errorResponse = new ErrorResponse(new StringReader(bodyContent))).code() != null) {
            throw new ErrorResponseException(errorResponse, response.response());
        }
    }

    private Iterable<Result<Part>> listObjectParts(final String bucketName, final String objectName, final String uploadId) {
        return new Iterable<Result<Part>>(){

            @Override
            public Iterator<Result<Part>> iterator() {
                return new Iterator<Result<Part>>(){
                    private int nextPartNumberMarker;
                    private ListPartsResult listPartsResult;
                    private Result<Part> error;
                    private Iterator<Part> partIterator;
                    private boolean completed = false;

                    private synchronized void populate() {
                        this.listPartsResult = null;
                        this.partIterator = null;
                        try {
                            this.listPartsResult = MinioClient.this.listObjectParts(bucketName, objectName, uploadId, this.nextPartNumberMarker);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            this.partIterator = this.listPartsResult != null ? this.listPartsResult.partList().iterator() : new LinkedList().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.partIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Part> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.partIterator.hasNext()) {
                            return new Result<Part>(this.partIterator.next(), null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ListPartsResult listObjectParts(String bucketName, String objectName, String uploadId, int partNumberMarker) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        if (partNumberMarker > 0) {
            queryParamMap.put("part-number-marker", Integer.toString(partNumberMarker));
        }
        HttpResponse response = this.executeGet(bucketName, objectName, null, queryParamMap);
        ListPartsResult result = new ListPartsResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result;
    }

    private void abortMultipartUpload(String bucketName, String objectName, String uploadId) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        this.executeDelete(bucketName, objectName, queryParamMap);
    }

    public void removeIncompleteUpload(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
        for (Result<Upload> r : this.listIncompleteUploads(bucketName, objectName, true, false)) {
            Upload upload = r.get();
            if (!objectName.equals(upload.objectName())) continue;
            this.abortMultipartUpload(bucketName, objectName, upload.uploadId());
            return;
        }
    }

    private void skipStream(Object inputStream, long n) throws IOException, InsufficientDataException {
        long bytesSkipped;
        RandomAccessFile file = null;
        BufferedInputStream stream = null;
        if (inputStream instanceof RandomAccessFile) {
            file = (RandomAccessFile)inputStream;
        } else if (inputStream instanceof BufferedInputStream) {
            stream = (BufferedInputStream)inputStream;
        } else {
            throw new IllegalArgumentException("unsupported input stream object");
        }
        if (file != null) {
            file.seek(file.getFilePointer() + n);
            return;
        }
        long totalBytesSkipped = 0L;
        while ((bytesSkipped = stream.skip(n - totalBytesSkipped)) >= 0L) {
            if ((totalBytesSkipped += bytesSkipped) != n) continue;
            return;
        }
        throw new InsufficientDataException("Insufficient data.  bytes skipped " + totalBytesSkipped + " expected " + n);
    }

    private static int[] calculateMultipartSize(long size) throws InvalidArgumentException {
        double partCount;
        if (size > 0x50000000000L) {
            throw new InvalidArgumentException("size " + size + " is greater than allowed size 5TiB");
        }
        double partSize = Math.ceil((double)size / 10000.0);
        double lastPartSize = (partSize = Math.ceil(partSize / 5242880.0) * 5242880.0) - (partSize * (partCount = Math.ceil((double)size / partSize)) - (double)size);
        if (lastPartSize == 0.0) {
            lastPartSize = partSize;
        }
        return new int[]{(int)partSize, (int)partCount, (int)lastPartSize};
    }

    public void traceOn(OutputStream traceStream) {
        if (traceStream == null) {
            throw new NullPointerException();
        }
        this.traceStream = new PrintWriter((Writer)new OutputStreamWriter(traceStream, StandardCharsets.UTF_8), true);
    }

    public void traceOff() throws IOException {
        this.traceStream = null;
    }

    static {
        try {
            xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

