/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.io.BaseEncoding;
import io.minio.errors.InsufficientDataException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class Digest {
    private Digest() {
    }

    public static String sha256Hash(String string) throws NoSuchAlgorithmException {
        return Digest.sha256Hash(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha256Hash(byte[] data) throws NoSuchAlgorithmException {
        return Digest.sha256Hash(data, data.length);
    }

    public static String sha256Hash(byte[] data, int length) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(data, 0, length);
        return BaseEncoding.base16().encode(messageDigest.digest()).toLowerCase();
    }

    public static String md5Hash(String string) throws NoSuchAlgorithmException {
        return Digest.md5Hash(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String md5Hash(byte[] data) throws NoSuchAlgorithmException {
        return Digest.md5Hash(data, data.length);
    }

    public static String md5Hash(byte[] data, int length) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(data, 0, length);
        return BaseEncoding.base64().encode(messageDigest.digest());
    }

    public static String md5Hash(Object inputStream, int len) throws NoSuchAlgorithmException, IOException, InsufficientDataException {
        RandomAccessFile file = null;
        BufferedInputStream stream = null;
        if (inputStream instanceof RandomAccessFile) {
            file = (RandomAccessFile)inputStream;
        } else if (inputStream instanceof BufferedInputStream) {
            stream = (BufferedInputStream)inputStream;
        } else {
            throw new IllegalArgumentException("unsupported input stream object");
        }
        long pos = 0L;
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        pos = Digest.readBytes(len, file, stream, pos, null, md5Digest);
        if (file != null) {
            file.seek(pos);
        } else {
            stream.reset();
        }
        return BaseEncoding.base64().encode(md5Digest.digest());
    }

    public static String[] sha256md5Hashes(String string) throws NoSuchAlgorithmException {
        return Digest.sha256md5Hashes(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String[] sha256md5Hashes(byte[] data) throws NoSuchAlgorithmException {
        return Digest.sha256md5Hashes(data, data.length);
    }

    public static String[] sha256md5Hashes(byte[] data, int length) throws NoSuchAlgorithmException {
        return new String[]{Digest.sha256Hash(data, length), Digest.md5Hash(data, length)};
    }

    public static String[] sha256md5Hashes(Object inputStream, int len) throws NoSuchAlgorithmException, IOException, InsufficientDataException {
        RandomAccessFile file = null;
        BufferedInputStream stream = null;
        if (inputStream instanceof RandomAccessFile) {
            file = (RandomAccessFile)inputStream;
        } else if (inputStream instanceof BufferedInputStream) {
            stream = (BufferedInputStream)inputStream;
        } else {
            throw new IllegalArgumentException("unsupported input stream object");
        }
        MessageDigest sha256Digest = MessageDigest.getInstance("SHA-256");
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        long pos = 0L;
        pos = Digest.readBytes(len, file, stream, pos, sha256Digest, md5Digest);
        if (file != null) {
            file.seek(pos);
        } else {
            stream.reset();
        }
        return new String[]{BaseEncoding.base16().encode(sha256Digest.digest()).toLowerCase(), BaseEncoding.base64().encode(md5Digest.digest())};
    }

    private static long readBytes(int len, RandomAccessFile file, BufferedInputStream stream, long pos, MessageDigest sha256Digest, MessageDigest md5Digest) throws IOException, InsufficientDataException {
        byte[] buf = new byte[16384];
        int bytesToRead = buf.length;
        int totalBytesRead = 0;
        int length = len;
        if (file != null) {
            pos = file.getFilePointer();
        } else {
            stream.mark(len);
        }
        do {
            int bytesRead;
            if (length - totalBytesRead < bytesToRead) {
                bytesToRead = length - totalBytesRead;
            }
            if ((bytesRead = file != null ? file.read(buf, 0, bytesToRead) : stream.read(buf, 0, bytesToRead)) < 0) {
                throw new InsufficientDataException("Insufficient data.  bytes read " + totalBytesRead + " expected " + length);
            }
            if (bytesRead == 0) continue;
            if (sha256Digest != null) {
                sha256Digest.update(buf, 0, bytesRead);
            }
            if (md5Digest != null) {
                md5Digest.update(buf, 0, bytesRead);
            }
            totalBytesRead += bytesRead;
        } while (totalBytesRead < length);
        return pos;
    }
}

