/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.support.server;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

@Singleton
@Primary
@Order(value=-100)
@Requirements(value={@Requires(property="micronaut.test.server.url"), @Requires(missingProperty="micronaut.test.server.executable")})
public class TestEmbeddedServer
implements EmbeddedServer {
    public static final String PROPERTY = "micronaut.test.server.url";
    private final ApplicationContext applicationContext;
    private final URL url;
    private final ApplicationConfiguration applicationConfiguration;

    @Internal
    protected TestEmbeddedServer(@Property(name="micronaut.test.server.url") URL url, ApplicationConfiguration applicationConfiguration, ApplicationContext applicationContext) {
        this.url = url;
        this.applicationConfiguration = applicationConfiguration;
        this.applicationContext = applicationContext;
    }

    public int getPort() {
        return this.getURL().getPort();
    }

    public String getHost() {
        return this.getURL().getHost();
    }

    public String getScheme() {
        return this.getURL().getProtocol();
    }

    public URL getURL() {
        return this.url;
    }

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid Server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public boolean isRunning() {
        return !SocketUtils.isTcpPortAvailable((int)this.getPort()) && this.applicationContext.isRunning();
    }

    public boolean isServer() {
        return true;
    }
}

