/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.transaction;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requires;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.context.TestExecutionListener;
import io.micronaut.test.transaction.TestTransactionInterceptor;

@EachBean(value=TestTransactionInterceptor.class)
@Requires(property="micronaut.test.transactional", value="true", defaultValue="true")
public class TestTransactionInterceptorListener
implements TestExecutionListener {
    private final TestTransactionInterceptor interceptor;
    private final boolean rollback;

    public TestTransactionInterceptorListener(TestTransactionInterceptor interceptor, @Property(name="micronaut.test.rollback") boolean rollback) {
        this.interceptor = interceptor;
        this.rollback = rollback;
    }

    @Override
    public void afterTestExecution(TestContext testContext) {
        if (this.rollback) {
            this.interceptor.rollback();
        } else {
            this.interceptor.commit();
        }
    }

    @Override
    public void beforeTestExecution(TestContext testContext) {
        this.interceptor.begin();
    }
}

