/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.processor.jackson.ValidatingAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class JsonTypeInfoMapper
extends ValidatingAnnotationMapper {
    public String getName() {
        return "com.fasterxml.jackson.annotation.JsonTypeInfo";
    }

    @Override
    protected Set<String> getSupportedMemberNames() {
        return CollectionUtils.setOf((Object[])new String[]{"defaultImpl", "property", "include", "use", "visible"});
    }

    @Override
    protected List<AnnotationValue<?>> mapValid(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String use = annotation.stringValue("use").orElse(null);
        if (use == null) {
            return this.mapError("You must specify 'use' member when using @JsonTypeInfo");
        }
        ArrayList values = new ArrayList(2);
        AnnotationClassValue defaultImpl = annotation.annotationClassValue("defaultImpl").orElse(null);
        if (defaultImpl != null) {
            values.add(AnnotationValue.builder(DefaultImplementation.class).member("value", new AnnotationClassValue[]{defaultImpl}).build());
        }
        AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.SerSubtyped.class);
        builder.member("discriminatorVisible", annotation.booleanValue("visible").orElse(false).booleanValue());
        String include = annotation.stringValue("include").orElse("PROPERTY");
        builder.member("dt", include);
        Optional propertyValue = annotation.stringValue("property");
        switch (use) {
            case "CLASS": {
                builder.member("dv", (Enum)SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME);
                builder.member("dp", propertyValue.orElse("@class"));
                break;
            }
            case "NAME": {
                builder.member("dv", (Enum)SerdeConfig.SerSubtyped.DiscriminatorValueKind.NAME);
                builder.member("dp", propertyValue.orElse("@type"));
                break;
            }
            case "MINIMAL_CLASS": {
                builder.member("dv", (Enum)SerdeConfig.SerSubtyped.DiscriminatorValueKind.MINIMAL_CLASS);
                builder.member("dp", propertyValue.orElse("@c"));
                break;
            }
            default: {
                return this.mapError("Unsupported JsonTypeInfo use: " + use);
            }
        }
        values.add(builder.build());
        return values;
    }

    private List<AnnotationValue<?>> mapError(String message) {
        return Collections.singletonList(AnnotationValue.builder(SerdeConfig.SerError.class).value(message).build());
    }
}

