/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class JsonPropertyMapper
implements NamedAnnotationMapper {
    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.class);
        String propertyName = annotation.stringValue().orElse(null);
        ArrayList values = new ArrayList();
        if (propertyName != null) {
            builder.member("property", propertyName);
        } else {
            values.add(AnnotationValue.builder((String)"Property").build());
        }
        annotation.stringValue("defaultValue").ifPresent(s -> values.add(AnnotationValue.builder(Bindable.class).member("defaultValue", s).build()));
        annotation.stringValue("access").ifPresent(access -> {
            switch (access) {
                case "READ_ONLY": {
                    builder.member("readOnly", true);
                    break;
                }
                case "WRITE_ONLY": {
                    builder.member("writeOnly", true);
                    break;
                }
            }
        });
        if (annotation.booleanValue("required").orElse(false).booleanValue()) {
            builder.member("required", true);
        }
        values.add(builder.build());
        return values;
    }

    public String getName() {
        return "com.fasterxml.jackson.annotation.JsonProperty";
    }
}

