/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.env.DefaultEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.reactivestreams.Processor;

final class ObjectMappers {
    private static volatile ObjectMapper defaultObjectMapper;
    private static volatile ApplicationContext beanContext;
    private static final Object MAPPER_LOCK;
    private static final Object CONTEXT_LOCK;

    private ObjectMappers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectMapper resolveDefault() {
        ObjectMapper objectMapper = defaultObjectMapper;
        if (objectMapper == null) {
            Object object = MAPPER_LOCK;
            synchronized (object) {
                objectMapper = defaultObjectMapper;
                if (objectMapper == null) {
                    defaultObjectMapper = objectMapper = (ObjectMapper)ObjectMappers.resolveBeanContext().getBean(ObjectMapper.class);
                }
            }
        }
        return objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApplicationContext resolveBeanContext() {
        ApplicationContext context = beanContext;
        if (context == null) {
            Object object = CONTEXT_LOCK;
            synchronized (object) {
                context = beanContext;
                if (context == null) {
                    beanContext = context = new ObjectMapperContext(null).start();
                }
            }
        }
        return context;
    }

    static ObjectMapper.CloseableObjectMapper create(Map<String, Object> configuration, final String ... packageNames) {
        final ObjectMapperContext context = new ObjectMapperContext(configuration){

            @Override
            protected Set<String> getIncludedPackages() {
                Set<String> includedPackages = super.getIncludedPackages();
                includedPackages.addAll(CollectionUtils.setOf((Object[])packageNames));
                return includedPackages;
            }
        };
        context.start();
        final ObjectMapper objectMapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        return new ObjectMapper.CloseableObjectMapper(){

            public <T> T readValueFromTree(JsonNode tree, Argument<T> type) throws IOException {
                return (T)objectMapper.readValueFromTree(tree, type);
            }

            public <T> T readValue(InputStream inputStream, Argument<T> type) throws IOException {
                return (T)objectMapper.readValue(inputStream, type);
            }

            public <T> T readValue(byte[] byteArray, Argument<T> type) throws IOException {
                return (T)objectMapper.readValue(byteArray, type);
            }

            public Processor<byte[], JsonNode> createReactiveParser(Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
                return objectMapper.createReactiveParser(onSubscribe, streamArray);
            }

            public JsonNode writeValueToTree(Object value) throws IOException {
                return objectMapper.writeValueToTree(value);
            }

            public <T> JsonNode writeValueToTree(Argument<T> type, T value) throws IOException {
                return this.writeValueToTree(type, value);
            }

            public void writeValue(OutputStream outputStream, Object object) throws IOException {
                objectMapper.writeValue(outputStream, object);
            }

            public <T> void writeValue(OutputStream outputStream, Argument<T> type, T object) throws IOException {
                objectMapper.writeValue(outputStream, type, object);
            }

            public byte[] writeValueAsBytes(Object object) throws IOException {
                return objectMapper.writeValueAsBytes(object);
            }

            public <T> byte[] writeValueAsBytes(Argument<T> type, T object) throws IOException {
                return objectMapper.writeValueAsBytes(type, object);
            }

            public JsonStreamConfig getStreamConfig() {
                return objectMapper.getStreamConfig();
            }

            @Override
            public void close() {
                context.close();
            }
        };
    }

    static {
        MAPPER_LOCK = new Object();
        CONTEXT_LOCK = new Object();
    }

    private static class ObjectMapperContext
    extends DefaultApplicationContext {
        private final Map<String, Object> config;

        private ObjectMapperContext(@Nullable Map<String, Object> config) {
            super(new String[0]);
            this.config = config;
        }

        protected Set<String> getIncludedPackages() {
            return CollectionUtils.setOf((Object[])new String[]{"io.micronaut.serde", "io.micronaut.aop", "io.micronaut.runtime.context.env"});
        }

        protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
            return super.resolveBeanDefinitionReferences().stream().filter(ref -> this.getIncludedPackages().stream().anyMatch(n -> ref.getBeanDefinitionName().startsWith((String)n))).toList();
        }

        public Future<Void> publishEventAsync(Object event) {
            return CompletableFuture.completedFuture(null);
        }

        public void publishEvent(Object event) {
        }

        protected Environment createEnvironment(ApplicationContextConfiguration configuration) {
            return new DefaultEnvironment((ApplicationContextConfiguration)this.getContextConfiguration()){

                protected void readPropertySources(String name) {
                    if (config != null) {
                        this.processPropertySource(PropertySource.of(config), PropertySource.PropertyConvention.JAVA_PROPERTIES);
                    }
                }
            };
        }
    }
}

