/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.type.ReturnType;
import io.micronaut.http.HttpResponse;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.util.KotlinExecutableMethodUtils;
import io.micronaut.web.router.MethodBasedRouteMatch;

public interface RouteInfo<R>
extends AnnotationMetadataProvider {
    public ReturnType<? extends R> getReturnType();

    default public boolean isSuspended() {
        return this.getReturnType().isSuspended();
    }

    default public boolean isReactive() {
        return this.getReturnType().isReactive();
    }

    default public boolean isSingleResult() {
        ReturnType<R> returnType = this.getReturnType();
        return returnType.isSingleResult() || this.isReactive() && returnType.getFirstTypeVariable().filter(t -> HttpResponse.class.isAssignableFrom(t.getType())).isPresent() || returnType.isSuspended();
    }

    default public boolean isSpecifiedSingle() {
        return this.getReturnType().isSpecifiedSingle();
    }

    default public boolean isCompletable() {
        return this.getReturnType().isCompletable();
    }

    default public boolean isAsync() {
        return this.getReturnType().isAsync();
    }

    default public boolean isAsyncOrReactive() {
        return this.getReturnType().isAsyncOrReactive();
    }

    default public boolean isVoid() {
        if (this.getReturnType().isVoid()) {
            return true;
        }
        if (this instanceof MethodBasedRouteMatch && this.isSuspended()) {
            return KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit((ExecutableMethod)((MethodBasedRouteMatch)this).getExecutableMethod());
        }
        return false;
    }
}

