/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpStatus;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.StatusRouteMatch;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
class ErrorRouteMatch<T, R>
extends StatusRouteMatch<T, R> {
    private final Throwable error;
    private final Map<String, Object> variables;

    ErrorRouteMatch(Throwable error, DefaultRouteBuilder.AbstractRoute abstractRoute, ConversionService<?> conversionService) {
        super(HttpStatus.INTERNAL_SERVER_ERROR, abstractRoute, conversionService);
        this.error = error;
        this.variables = new LinkedHashMap<String, Object>();
        for (Argument argument : this.getArguments()) {
            if (!argument.getType().isInstance(error)) continue;
            this.variables.put(argument.getName(), error);
        }
    }

    @Override
    public Collection<Argument> getRequiredArguments() {
        return Arrays.stream(this.getArguments()).filter(argument -> !argument.getType().isInstance(this.error)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getVariableValues() {
        return this.variables;
    }

    public String toString() {
        return this.abstractRoute.toString();
    }
}

