/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.retry.RetryState;
import io.micronaut.retry.annotation.DefaultRetryPredicate;
import io.micronaut.retry.annotation.RetryPredicate;
import io.micronaut.retry.intercept.MutableRetryState;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class SimpleRetry
implements RetryState,
MutableRetryState {
    private final int maxAttempts;
    private final double multiplier;
    private final Duration delay;
    private final Duration maxDelay;
    private final AtomicInteger attemptNumber = new AtomicInteger(0);
    private final AtomicLong overallDelay = new AtomicLong(0L);
    private final RetryPredicate predicate;
    private final Class<? extends Throwable> capturedException;
    private final double jitter;

    SimpleRetry(int maxAttempts, double multiplier, Duration delay, Duration maxDelay, RetryPredicate predicate, Class<? extends Throwable> capturedException, double jitter) {
        this.maxAttempts = maxAttempts;
        this.multiplier = multiplier;
        this.delay = delay;
        this.maxDelay = maxDelay;
        this.predicate = predicate;
        this.capturedException = capturedException;
        this.jitter = jitter;
    }

    SimpleRetry(int maxAttempts, double multiplier, Duration delay, Duration maxDelay, Class<? extends Throwable> capturedException, double jitter) {
        this(maxAttempts, multiplier, delay, maxDelay, new DefaultRetryPredicate(), capturedException, jitter);
    }

    SimpleRetry(int maxAttempts, double multiplier, Duration delay, double jitter) {
        this(maxAttempts, multiplier, delay, null, null, jitter);
    }

    @Override
    public boolean canRetry(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (!this.predicate.test(exception)) {
            return false;
        }
        return this.attemptNumber.incrementAndGet() < this.maxAttempts + 1 && (this.maxDelay == null || this.overallDelay.get() < this.maxDelay.toMillis());
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public int currentAttempt() {
        return this.attemptNumber.get();
    }

    @Override
    public OptionalDouble getMultiplier() {
        return this.multiplier > 0.0 ? OptionalDouble.of(this.multiplier) : OptionalDouble.empty();
    }

    @Override
    public Duration getDelay() {
        return this.delay;
    }

    @Override
    public Duration getOverallDelay() {
        return Duration.ofMillis(this.overallDelay.get());
    }

    @Override
    public Optional<Duration> getMaxDelay() {
        return Optional.ofNullable(this.maxDelay);
    }

    @Override
    public RetryPredicate getRetryPredicate() {
        return this.predicate;
    }

    @Override
    public Class<? extends Throwable> getCapturedException() {
        return this.capturedException;
    }

    @Override
    public OptionalDouble getJitter() {
        return this.jitter > 0.0 ? OptionalDouble.of(this.jitter) : OptionalDouble.empty();
    }

    @Override
    @Internal
    public long nextDelay() {
        double multiplier = this.getMultiplier().orElse(1.0);
        long delay = (long)((double)this.getDelay().toMillis() * StrictMath.pow(multiplier, this.attemptNumber.get() - 1));
        double jitter = this.getJitter().orElse(0.0);
        if (jitter > 0.0) {
            delay = Math.max(0L, (long)((double)delay * (1.0 + ThreadLocalRandom.current().nextDouble(-jitter, jitter))));
        }
        this.overallDelay.addAndGet(delay);
        return delay;
    }
}

