/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Produces
public class ConversionErrorHandler
implements ExceptionHandler<ConversionErrorException, HttpResponse> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public ConversionErrorHandler() {
        this.responseProcessor = null;
    }

    @Inject
    public ConversionErrorHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public HttpResponse handle(HttpRequest request, final ConversionErrorException exception) {
        MutableHttpResponse response = HttpResponse.badRequest();
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder(request).cause((Throwable)exception).error(new Error(){

                @Override
                public Optional<String> getPath() {
                    return Optional.of('/' + exception.getArgument().getName());
                }

                @Override
                public String getMessage() {
                    return exception.getMessage();
                }
            }).build(), response);
        }
        return response.body((Object)new JsonError(exception.getMessage()).path('/' + exception.getArgument().getName()).link(Link.SELF, Link.of((URI)request.getUri())));
    }
}

