/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProxyHeaderParser {
    private static final String FOR = "for";
    private static final String BY = "by";
    private static final String HOST = "host";
    private static final String PROTO = "proto";
    private static final String PARAM_DELIMITER = ";";
    private static final String ELEMENT_DELIMITER = ",";
    private static final String PAIR_DELIMITER = "=";
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_PORT = "X-Forwarded-Port";
    private List<String> forwardedFor = new ArrayList<String>();
    private String forwardedBy = null;
    private String forwardedHost = null;
    private String forwardedProto = null;
    private Integer forwardedPort = null;

    public ProxyHeaderParser(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        if (headers.contains("Forwarded")) {
            headers.getAll((CharSequence)"Forwarded").stream().flatMap(header -> {
                if (header.contains(ELEMENT_DELIMITER)) {
                    return Arrays.stream(header.split(ELEMENT_DELIMITER));
                }
                return Stream.of(header);
            }).forEach(forwarded -> {
                String[] params;
                for (String param : params = forwarded.split(PARAM_DELIMITER)) {
                    String[] parts = param.split(PAIR_DELIMITER);
                    if (parts.length != 2) continue;
                    String key = parts[0].trim();
                    String value = this.trimQuotes(parts[1].trim());
                    if (key.equalsIgnoreCase(FOR)) {
                        this.forwardedFor.add(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase(BY) && this.forwardedBy == null) {
                        this.forwardedBy = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase(PROTO) && this.forwardedProto == null) {
                        this.forwardedProto = value;
                        continue;
                    }
                    if (!key.equalsIgnoreCase(HOST) || this.forwardedHost != null) continue;
                    if (value.contains(":")) {
                        String[] host = value.split(":");
                        this.forwardedHost = host[0];
                        this.forwardedPort = Integer.valueOf(host[1]);
                        continue;
                    }
                    this.forwardedHost = value;
                }
            });
        } else {
            this.forwardedProto = StringUtils.trimToNull((String)((String)headers.get((CharSequence)X_FORWARDED_PROTO)));
            this.forwardedHost = (String)headers.get((CharSequence)X_FORWARDED_HOST);
            try {
                if (this.forwardedHost != null && this.forwardedHost.contains(":")) {
                    String[] parts = this.forwardedHost.split(":");
                    this.forwardedHost = parts[0];
                    this.forwardedPort = Integer.valueOf(parts[1]);
                } else {
                    String portHeader = (String)headers.get((CharSequence)X_FORWARDED_PORT);
                    if (portHeader != null) {
                        this.forwardedPort = Integer.valueOf(portHeader);
                    }
                }
            }
            catch (NumberFormatException portHeader) {
                // empty catch block
            }
            String forwardedForHeader = (String)headers.get((CharSequence)X_FORWARDED_FOR);
            if (forwardedForHeader != null) {
                this.forwardedFor = Arrays.stream(forwardedForHeader.split(ELEMENT_DELIMITER)).map(String::trim).collect(Collectors.toList());
            }
        }
    }

    @NonNull
    public List<String> getFor() {
        return this.forwardedFor;
    }

    public String getBy() {
        return this.forwardedBy;
    }

    public String getHost() {
        return this.forwardedHost;
    }

    public String getScheme() {
        return this.forwardedProto;
    }

    public Integer getPort() {
        return this.forwardedPort;
    }

    private String trimQuotes(String value) {
        if (value != null && value.startsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

