/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.context.annotation.Primary;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import java.net.URISyntaxException;
import javax.inject.Singleton;

@Singleton
@Primary
@Produces
public class URISyntaxHandler
implements ExceptionHandler<URISyntaxException, HttpResponse> {
    @Override
    public HttpResponse handle(HttpRequest request, URISyntaxException exception) {
        JsonError error = new JsonError("Malformed URI: " + exception.getMessage());
        return HttpResponse.badRequest((Object)error);
    }
}

