/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty.websocket;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.DefaultExecutableBinder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.websocket.AbstractNettyWebSocketHandler;
import io.micronaut.http.netty.websocket.NettyRxWebSocketSession;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.bind.WebSocketState;
import io.micronaut.websocket.bind.WebSocketStateBinderRegistry;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.exceptions.WebSocketClientException;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.micronaut.websocket.interceptor.WebSocketSessionAware;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
public class NettyWebSocketClientHandler<T>
extends AbstractNettyWebSocketHandler {
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketBean<T> webSocketBean;
    private final MutableHttpRequest<?> originatingRequest;
    private final FlowableEmitter<T> emitter;
    private final UriMatchInfo matchInfo;
    private final MediaTypeCodecRegistry codecRegistry;
    private ChannelPromise handshakeFuture;
    private NettyRxWebSocketSession clientSession;
    private WebSocketStateBinderRegistry webSocketStateBinderRegistry;
    private FullHttpResponse handshakeResponse;
    private Argument<?> clientBodyArgument;

    public NettyWebSocketClientHandler(MutableHttpRequest<?> request, WebSocketBean<T> webSocketBean, WebSocketClientHandshaker handshaker, RequestBinderRegistry requestBinderRegistry, MediaTypeCodecRegistry mediaTypeCodecRegistry, FlowableEmitter<T> emitter) {
        super(null, requestBinderRegistry, mediaTypeCodecRegistry, webSocketBean, request, Collections.emptyMap(), handshaker.version(), null);
        this.codecRegistry = mediaTypeCodecRegistry;
        this.handshaker = handshaker;
        this.webSocketBean = webSocketBean;
        this.originatingRequest = request;
        this.emitter = emitter;
        this.webSocketStateBinderRegistry = new WebSocketStateBinderRegistry((RequestBinderRegistry)(requestBinderRegistry != null ? requestBinderRegistry : new DefaultRequestBinderRegistry(ConversionService.SHARED, new RequestArgumentBinder[0])));
        String clientPath = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("");
        UriMatchTemplate matchTemplate = UriMatchTemplate.of((String)clientPath);
        this.matchInfo = matchTemplate.match(request.getPath()).orElse(null);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent.state() == IdleState.ALL_IDLE && this.clientSession != null && this.clientSession.isOpen()) {
                this.clientSession.close(CloseReason.NORMAL);
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public Argument<?> getBodyArgument() {
        return this.clientBodyArgument;
    }

    public NettyRxWebSocketSession getSession() {
        return this.clientSession;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            block15: {
                DefaultExecutableBinder binder;
                BoundExecutable bound;
                List unboundArguments;
                FullHttpResponse res;
                this.handshakeResponse = res = (FullHttpResponse)msg;
                this.handshaker.finishHandshake(ch, res);
                this.handshakeFuture.setSuccess();
                this.clientSession = this.createWebSocketSession(ctx);
                Object targetBean = this.webSocketBean.getTarget();
                if (targetBean instanceof WebSocketSessionAware) {
                    ((WebSocketSessionAware)targetBean).setWebSocketSession((WebSocketSession)this.clientSession);
                }
                if ((unboundArguments = (bound = (binder = new DefaultExecutableBinder()).tryBind((Executable)this.messageHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)this.clientSession, this.originatingRequest))).getUnboundArguments()).size() != 1) {
                    this.clientBodyArgument = null;
                    try {
                        this.emitter.onError((Throwable)new WebSocketClientException("WebSocket @OnMessage method " + targetBean.getClass().getSimpleName() + "." + this.messageHandler.getExecutableMethod() + " should define exactly 1 message parameter, but found 2 possible candidates: " + unboundArguments));
                    }
                    finally {
                        if (this.getSession().isOpen()) {
                            this.getSession().close(CloseReason.INTERNAL_ERROR);
                        }
                    }
                    return;
                }
                this.clientBodyArgument = (Argument)unboundArguments.iterator().next();
                Optional opt = this.webSocketBean.openMethod();
                if (opt.isPresent()) {
                    MethodExecutionHandle openMethod = (MethodExecutionHandle)opt.get();
                    WebSocketState webSocketState = new WebSocketState((WebSocketSession)this.clientSession, this.originatingRequest);
                    try {
                        BoundExecutable openMethodBound = binder.bind((Executable)openMethod.getExecutableMethod(), (ArgumentBinderRegistry)this.webSocketStateBinderRegistry, (Object)webSocketState);
                        Object target = openMethod.getTarget();
                        Object result = openMethodBound.invoke(target);
                        if (Publishers.isConvertibleToPublisher((Object)result)) {
                            Flowable flowable = (Flowable)Publishers.convertPublisher((Object)result, Flowable.class);
                            flowable.subscribe(o -> {}, error -> this.emitter.onError((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + error.getMessage(), error)), () -> {
                                this.emitter.onNext(targetBean);
                                this.emitter.onComplete();
                            });
                            break block15;
                        }
                        this.emitter.onNext(targetBean);
                        this.emitter.onComplete();
                    }
                    catch (Throwable e) {
                        this.emitter.onError((Throwable)new WebSocketClientException("Error opening WebSocket client session: " + e.getMessage(), e));
                        if (this.getSession().isOpen()) {
                            this.getSession().close(CloseReason.INTERNAL_ERROR);
                        }
                        break block15;
                    }
                }
                this.emitter.onNext(targetBean);
                this.emitter.onComplete();
            }
            return;
        }
        if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    protected NettyRxWebSocketSession createWebSocketSession(ChannelHandlerContext ctx) {
        if (ctx != null) {
            return new NettyRxWebSocketSession(this.handshakeResponse.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT), ctx.channel(), (HttpRequest)this.originatingRequest, this.codecRegistry, this.handshaker.version().toHttpHeaderValue(), ctx.pipeline().get(SslHandler.class) != null){

                public ConvertibleValues<Object> getUriVariables() {
                    if (NettyWebSocketClientHandler.this.matchInfo != null) {
                        return ConvertibleValues.of((Map)NettyWebSocketClientHandler.this.matchInfo.getVariableValues());
                    }
                    return ConvertibleValues.empty();
                }
            };
        }
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        super.exceptionCaught(ctx, cause);
    }
}

