/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.internal.intercepted.CompletionStageInterceptedMethod;
import io.micronaut.aop.internal.intercepted.KotlinInterceptedMethod;
import io.micronaut.aop.internal.intercepted.PublisherInterceptedMethod;
import io.micronaut.aop.internal.intercepted.SynchronousInterceptedMethod;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.ReturnType;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;

public class InterceptedMethodUtil {
    public static InterceptedMethod of(MethodInvocationContext<?, ?> context) {
        ReturnType returnType = context.getReturnType();
        Class returnTypeClass = returnType.getType();
        if (returnTypeClass == Void.TYPE || returnTypeClass == String.class) {
            return new SynchronousInterceptedMethod(context);
        }
        if (CompletionStage.class.isAssignableFrom(returnTypeClass) || Future.class.isAssignableFrom(returnTypeClass)) {
            return new CompletionStageInterceptedMethod(context);
        }
        if (Publishers.isConvertibleToPublisher((Class)returnTypeClass)) {
            return new PublisherInterceptedMethod(context);
        }
        KotlinInterceptedMethod kotlinInterceptedMethod = KotlinInterceptedMethod.of(context);
        if (kotlinInterceptedMethod != null) {
            return kotlinInterceptedMethod;
        }
        return new SynchronousInterceptedMethod(context);
    }
}

