/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop;

import io.micronaut.aop.Interceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.type.Argument;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public interface InterceptedMethod {
    public static InterceptedMethod of(MethodInvocationContext<?, ?> context) {
        return InterceptedMethodUtil.of(context);
    }

    public ResultType resultType();

    public Argument<?> returnTypeValue();

    public Object interceptResult();

    public Object interceptResult(Interceptor<?, ?> var1);

    default public CompletionStage<?> interceptResultAsCompletionStage() {
        if (this.resultType() != ResultType.COMPLETION_STAGE) {
            throw new ConfigurationException("Cannot return `CompletionStage` result from '" + (Object)((Object)this.resultType()) + "' interceptor");
        }
        return (CompletionStage)this.interceptResult();
    }

    default public Publisher<?> interceptResultAsPublisher() {
        if (this.resultType() != ResultType.PUBLISHER) {
            throw new ConfigurationException("Cannot return `Publisher` result from '" + (Object)((Object)this.resultType()) + "' interceptor");
        }
        return (Publisher)this.interceptResult();
    }

    default public CompletionStage<?> interceptResultAsCompletionStage(Interceptor<?, ?> from) {
        if (this.resultType() != ResultType.COMPLETION_STAGE) {
            throw new ConfigurationException("Cannot return `CompletionStage` result from '" + (Object)((Object)this.resultType()) + "' interceptor");
        }
        return (CompletionStage)this.interceptResult(from);
    }

    default public Publisher<?> interceptResultAsPublisher(Interceptor<?, ?> from) {
        if (this.resultType() != ResultType.PUBLISHER) {
            throw new ConfigurationException("Cannot return `Publisher` result from '" + (Object)((Object)this.resultType()) + "' interceptor");
        }
        return (Publisher)this.interceptResult(from);
    }

    public Object handleResult(Object var1);

    public <E extends Throwable> Object handleException(Exception var1) throws E;

    default public Object unsupported() {
        throw new ConfigurationException("Cannot intercept method invocation, missing '" + (Object)((Object)this.resultType()) + "' interceptor configured");
    }

    public static enum ResultType {
        COMPLETION_STAGE,
        PUBLISHER,
        SYNCHRONOUS;

    }
}

