/*
This file is part of Textricator.
Copyright 2018 Measures for Justice Institute.

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License version 3 as published by the
Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License along
with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

package io.mfj.textricator.form.config

import java.io.File
import java.io.InputStream

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory
import com.fasterxml.jackson.module.kotlin.*

object FormParseConfigUtil {

  private val mapper = ObjectMapper(YAMLFactory()).registerKotlinModule()

  fun parseYaml(file: File):FormParseConfig = parseYaml(file.readText())

  fun parseYaml(input:InputStream):FormParseConfig = mapper.readValue(input)

  fun parseYaml(text:String):FormParseConfig = mapper.readValue(text)

}
