/*
 * Decompiled with CFR 0.152.
 */
package io.mfj.expr;

import io.mfj.expr.ExConvertKt;
import io.mfj.expr.ExMathOpType;
import io.mfj.expr.ExValue;
import io.mfj.expr.VarProvider;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/mfj/expr/ExprMathStatement;", "", "left", "Lio/mfj/expr/ExValue;", "op", "Lio/mfj/expr/ExMathOpType;", "right", "(Lio/mfj/expr/ExValue;Lio/mfj/expr/ExMathOpType;Lio/mfj/expr/ExValue;)V", "getLeft", "()Lio/mfj/expr/ExValue;", "getOp", "()Lio/mfj/expr/ExMathOpType;", "setOp", "(Lio/mfj/expr/ExMathOpType;)V", "getRight", "calc", "", "leftVal", "", "rightVal", "toString", "", "value", "vp", "Lio/mfj/expr/VarProvider;", "expr"})
public final class ExprMathStatement {
    @NotNull
    private final ExValue left;
    @NotNull
    private ExMathOpType op;
    @NotNull
    private final ExValue right;

    public ExprMathStatement(@NotNull ExValue left, @NotNull ExMathOpType op, @NotNull ExValue right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.left = left;
        this.op = op;
        this.right = right;
    }

    @NotNull
    public final ExValue getLeft() {
        return this.left;
    }

    @NotNull
    public final ExMathOpType getOp() {
        return this.op;
    }

    public final void setOp(@NotNull ExMathOpType exMathOpType) {
        Intrinsics.checkNotNullParameter((Object)((Object)exMathOpType), (String)"<set-?>");
        this.op = exMathOpType;
    }

    @NotNull
    public final ExValue getRight() {
        return this.right;
    }

    @NotNull
    public final Number value(@NotNull VarProvider vp) {
        Intrinsics.checkNotNullParameter((Object)vp, (String)"vp");
        Object leftVal = this.left.getValue(vp);
        Object rightVal = this.right.getValue(vp);
        if (leftVal == null || rightVal == null) {
            throw new IllegalArgumentException("Input values must not be null");
        }
        if (!(leftVal instanceof Number) || !(rightVal instanceof Number)) {
            throw new IllegalArgumentException("Input values must be numbers");
        }
        if (leftVal instanceof Integer && rightVal instanceof Integer) {
            return this.calc(((Number)leftVal).intValue(), this.op, ((Number)rightVal).intValue());
        }
        return this.calc((Number)leftVal, this.op, (Number)rightVal);
    }

    private final Number calc(Number leftVal, ExMathOpType op, Number rightVal) {
        Number number;
        BigDecimal l = ExConvertKt.asBigDecimal(leftVal);
        BigDecimal r = ExConvertKt.asBigDecimal(rightVal);
        switch (WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
            case 1: {
                BigDecimal bigDecimal = l.add(r);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.add(other)");
                number = bigDecimal;
                break;
            }
            case 2: {
                BigDecimal bigDecimal = l.subtract(r);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.subtract(other)");
                number = bigDecimal;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return number;
    }

    private final Number calc(int leftVal, ExMathOpType op, int rightVal) {
        Number number;
        switch (WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
            case 1: {
                number = leftVal + rightVal;
                break;
            }
            case 2: {
                number = leftVal - rightVal;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return number;
    }

    @NotNull
    public String toString() {
        return this.left + this.op.getSymbol() + this.right;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExMathOpType.values().length];
            nArray[ExMathOpType.PLUS.ordinal()] = 1;
            nArray[ExMathOpType.MINUS.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

