/*
 * Decompiled with CFR 0.152.
 */
package io.mfj.expr;

import io.mfj.expr.ExConvertKt;
import io.mfj.expr.ExDataType;
import io.mfj.expr.ExMathOpType;
import io.mfj.expr.ExValue;
import io.mfj.expr.VarProvider;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/mfj/expr/ExValueCompound;", "Lio/mfj/expr/ExValue;", "left", "op", "Lio/mfj/expr/ExMathOpType;", "right", "(Lio/mfj/expr/ExValue;Lio/mfj/expr/ExMathOpType;Lio/mfj/expr/ExValue;)V", "getLeft", "()Lio/mfj/expr/ExValue;", "getRight", "getType", "Lio/mfj/expr/ExDataType;", "getValue", "", "vp", "Lio/mfj/expr/VarProvider;", "getVariableName", "", "toString", "expr"})
public final class ExValueCompound
implements ExValue {
    @NotNull
    private final ExValue left;
    @NotNull
    private final ExMathOpType op;
    @NotNull
    private final ExValue right;

    public ExValueCompound(@NotNull ExValue left, @NotNull ExMathOpType op, @NotNull ExValue right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.left = left;
        this.op = op;
        this.right = right;
        if (this.left.getType() != ExDataType.NUMBER || this.right.getType() != ExDataType.NUMBER) {
            throw new IllegalArgumentException("Left and Right must be numbers");
        }
    }

    @NotNull
    public final ExValue getLeft() {
        return this.left;
    }

    @NotNull
    public final ExValue getRight() {
        return this.right;
    }

    @Override
    @Nullable
    public String getVariableName() {
        return null;
    }

    @Override
    @NotNull
    public ExDataType getType() {
        return ExDataType.NUMBER;
    }

    @Override
    @NotNull
    public Object getValue(@NotNull VarProvider vp) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)vp, (String)"vp");
        Object object = this.left.getValue(vp);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        BigDecimal left = ExConvertKt.asBigDecimal((Number)object);
        Object object2 = this.right.getValue(vp);
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        BigDecimal right = ExConvertKt.asBigDecimal((Number)object2);
        switch (WhenMappings.$EnumSwitchMapping$0[this.op.ordinal()]) {
            case 1: {
                BigDecimal bigDecimal2 = left.add(right);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.add(other)");
                bigDecimal = bigDecimal2;
                break;
            }
            case 2: {
                BigDecimal bigDecimal3 = left.subtract(right);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.subtract(other)");
                bigDecimal = bigDecimal3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bigDecimal;
    }

    @NotNull
    public String toString() {
        return this.left + " " + this.op + " " + this.right;
    }

    @Override
    public boolean isVariable() {
        return ExValue.DefaultImpls.isVariable(this);
    }

    @Override
    public boolean isLiteral() {
        return ExValue.DefaultImpls.isLiteral(this);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExMathOpType.values().length];
            nArray[ExMathOpType.PLUS.ordinal()] = 1;
            nArray[ExMathOpType.MINUS.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

