/*
 * Decompiled with CFR 0.152.
 */
package io.mfj.expr;

import io.mfj.expr.ExConvert$WhenMappings;
import io.mfj.expr.ExDataType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0013"}, d2={"Lio/mfj/expr/ExConvert;", "", "()V", "anyToBoolean", "v", "anyToDaysSinceEpoch", "anyToDouble", "anyToInt", "anyToLocalDate", "anyToLocalDateTime", "anyToLocalTime", "anyToLong", "anyToMillisSinceEpoch", "anyToString", "", "convert", "dataType", "Lio/mfj/expr/ExDataType;", "convertStr", "expr"})
public final class ExConvert {
    public static final ExConvert INSTANCE;

    @Nullable
    public final Object convert(@Nullable Object v, @NotNull ExDataType dataType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataType), (String)"dataType");
        try {
            Object object;
            switch (ExConvert$WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1: {
                    object = this.anyToString(v);
                    break;
                }
                case 2: {
                    String string = this.anyToString(v);
                    if (string == null) {
                        throw (Throwable)new IllegalArgumentException("Regex pattern cannot be null");
                    }
                    object = new Regex(string);
                    break;
                }
                case 3: {
                    object = this.anyToInt(v);
                    break;
                }
                case 4: {
                    object = this.anyToDouble(v);
                    break;
                }
                case 5: {
                    object = this.anyToLocalDate(v);
                    break;
                }
                case 6: {
                    object = this.anyToLocalTime(v);
                    break;
                }
                case 7: {
                    object = this.anyToLocalDateTime(v);
                    break;
                }
                case 8: {
                    object = this.anyToBoolean(v);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return object;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Error converting \"" + v + "\" to " + (Object)((Object)dataType) + " - " + e.getMessage(), e);
        }
    }

    @Nullable
    public final Object convertStr(@Nullable String v, @NotNull ExDataType dataType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataType), (String)"dataType");
        return this.convert(v, dataType);
    }

    @Nullable
    public final String anyToString(@Nullable Object v) {
        Object object = v;
        return object == null ? null : (object instanceof String ? (String)v : String.valueOf(v));
    }

    @Nullable
    public final Object anyToInt(@Nullable Object v) {
        Integer n;
        Object object = v;
        if (object == null) {
            n = null;
        } else if (object instanceof Integer) {
            n = (Integer)v;
        } else if (object instanceof Long) {
            n = (int)((Number)v).longValue();
        } else if (object instanceof String) {
            CharSequence charSequence = (CharSequence)v;
            boolean bl = false;
            n = charSequence.length() == 0 ? null : Integer.valueOf(new BigDecimal((String)v).setScale(0, RoundingMode.FLOOR).intValue());
        } else if (object instanceof Float) {
            n = (int)((Number)v).floatValue();
        } else if (object instanceof Double) {
            n = (int)((Number)v).doubleValue();
        } else if (object instanceof BigDecimal) {
            n = ((BigDecimal)v).setScale(0, RoundingMode.FLOOR).intValue();
        } else {
            String string = String.valueOf(v);
            boolean bl = false;
            n = Integer.parseInt(string);
        }
        return n;
    }

    @Nullable
    public final Object anyToLong(@Nullable Object v) {
        Long l;
        Object object = v;
        if (object == null) {
            l = null;
        } else if (object instanceof Integer) {
            l = ((Number)v).intValue();
        } else if (object instanceof Long) {
            l = (Long)v;
        } else if (object instanceof String) {
            CharSequence charSequence = (CharSequence)v;
            boolean bl = false;
            l = charSequence.length() == 0 ? null : Long.valueOf(new BigDecimal((String)v).setScale(0, RoundingMode.FLOOR).longValue());
        } else if (object instanceof Float) {
            l = (long)((Number)v).floatValue();
        } else if (object instanceof Double) {
            l = (long)((Number)v).doubleValue();
        } else if (object instanceof BigDecimal) {
            l = ((BigDecimal)v).setScale(0, RoundingMode.FLOOR).longValue();
        } else {
            String string = String.valueOf(v);
            boolean bl = false;
            l = Long.parseLong(string);
        }
        return l;
    }

    @Nullable
    public final Object anyToDouble(@Nullable Object v) {
        Double d;
        Object object = v;
        if (object == null) {
            d = null;
        } else if (object instanceof Integer) {
            d = ((Number)v).intValue();
        } else if (object instanceof Long) {
            d = ((Number)v).longValue();
        } else if (object instanceof Float) {
            d = ((Number)v).floatValue();
        } else if (object instanceof Double) {
            d = (Double)v;
        } else if (object instanceof String) {
            CharSequence charSequence = (CharSequence)v;
            boolean bl = false;
            if (charSequence.length() == 0) {
                d = null;
            } else {
                charSequence = (String)v;
                bl = false;
                d = Double.parseDouble((String)charSequence);
            }
        } else if (object instanceof BigDecimal) {
            d = ((BigDecimal)v).doubleValue();
        } else {
            String string = String.valueOf(v);
            boolean bl = false;
            d = Double.parseDouble(string);
        }
        return d;
    }

    @Nullable
    public final Object anyToBoolean(@Nullable Object v) {
        Boolean bl;
        Object object = v;
        if (object == null) {
            bl = null;
        } else if (object instanceof Boolean) {
            bl = (Boolean)v;
        } else if (object instanceof String) {
            CharSequence charSequence = (CharSequence)v;
            boolean bl2 = false;
            if (charSequence.length() == 0) {
                bl = null;
            } else {
                charSequence = (String)v;
                bl2 = false;
                bl = Boolean.parseBoolean((String)charSequence);
            }
        } else {
            String string = String.valueOf(v);
            boolean bl3 = false;
            bl = Boolean.parseBoolean(string);
        }
        return bl;
    }

    @Nullable
    public final Object anyToLocalDate(@Nullable Object v) {
        LocalDate localDate;
        Object object = v;
        if (object == null) {
            localDate = null;
        } else if (object instanceof Date) {
            localDate = ((Date)v).toInstant().atZone(ZoneId.of("UTC")).toLocalDate();
        } else if (object instanceof LocalDate) {
            localDate = (LocalDate)v;
        } else {
            if (object instanceof Integer) {
                throw (Throwable)new RuntimeException("Bad date (int) " + v);
            }
            if (object instanceof Long) {
                throw (Throwable)new RuntimeException("Bad date (long) " + v);
            }
            localDate = LocalDate.parse(String.valueOf(v), DateTimeFormatter.ISO_DATE);
        }
        return localDate;
    }

    @Nullable
    public final Object anyToLocalTime(@Nullable Object v) {
        Object object;
        Object object2 = v;
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof Date) {
            object = ((Date)v).toInstant().atZone(ZoneId.of("UTC")).toLocalTime();
        } else if (object2 instanceof LocalDate) {
            object = v;
        } else {
            if (object2 instanceof Integer) {
                throw (Throwable)new RuntimeException("Bad date (int) " + v);
            }
            if (object2 instanceof Long) {
                throw (Throwable)new RuntimeException("Bad date (long) " + v);
            }
            object = LocalTime.parse(String.valueOf(v), DateTimeFormatter.ISO_TIME);
        }
        return object;
    }

    @Nullable
    public final Object anyToLocalDateTime(@Nullable Object v) {
        Object object;
        Object object2 = v;
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof Date) {
            object = LocalDateTime.ofInstant(((Date)v).toInstant(), ZoneId.of("UTC"));
        } else if (object2 instanceof LocalDate) {
            object = v;
        } else {
            if (object2 instanceof Integer) {
                throw (Throwable)new RuntimeException("Bad datetime (int) " + v);
            }
            if (object2 instanceof Long) {
                throw (Throwable)new RuntimeException("Bad datetime (int) " + v);
            }
            object = LocalDateTime.parse(String.valueOf(v), DateTimeFormatter.ISO_DATE_TIME);
        }
        return object;
    }

    @Nullable
    public final Object anyToDaysSinceEpoch(@Nullable Object v) {
        Integer n;
        Object object = v;
        if (object == null) {
            n = null;
        } else if (object instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            n = (int)LocalDate.parse(sdf.format((Date)v)).toEpochDay();
        } else if (object instanceof LocalDate) {
            n = (int)((LocalDate)v).toEpochDay();
        } else if (object instanceof Integer) {
            n = (Integer)v;
        } else if (object instanceof Long) {
            n = (int)((Number)v).longValue();
        } else {
            String string = String.valueOf(v);
            boolean bl = false;
            n = Integer.parseInt(string);
        }
        return n;
    }

    @Nullable
    public final Object anyToMillisSinceEpoch(@Nullable Object v) {
        Integer n;
        Object object = v;
        if (object == null) {
            n = null;
        } else if (object instanceof Date) {
            n = (int)((Date)v).getTime();
        } else if (object instanceof LocalDateTime) {
            n = (int)((LocalDateTime)v).toInstant(ZoneOffset.UTC).toEpochMilli();
        } else if (object instanceof Integer) {
            n = (Integer)v;
        } else if (object instanceof Long) {
            n = (int)((Number)v).longValue();
        } else {
            String string = String.valueOf(v);
            boolean bl = false;
            n = Integer.parseInt(string);
        }
        return n;
    }

    private ExConvert() {
    }

    static {
        ExConvert exConvert;
        INSTANCE = exConvert = new ExConvert();
    }
}

