package io.maxads.ads.interstitial.vast3.xml_model;

import android.support.annotation.Nullable;

import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

import java.util.List;

@Root(name = "CompanionAd", strict = false)
public class CompanionAdXml implements ResourceXml {
  @Attribute(name = "width", required = false)
  @Nullable public Integer width;

  @Attribute(name = "height", required = false)
  @Nullable public Integer height;

  @Element(name = "HTMLResource", required = false)
  @Nullable public String htmlResource;

  @Element(name = "StaticResource", required = false)
  @Nullable public StaticResourceXml staticResource;

  @Element(name = "IFrameResource", required = false)
  @Nullable public String iFrameResource;

  @ElementList(name = "TrackingEvents", required = false)
  @Nullable public List<TrackingXml> trackingXmls;

  @Element(name = "CompanionClickThrough", required = false)
  @Nullable public String companionClickThrough;

  @ElementList(entry = "CompanionClickTracking", inline = true, required = false)
  @Nullable public List<String> companionClickTrackingUrls;

  @Nullable
  @Override
  public String getHTMLResource() {
    return htmlResource;
  }

  @Nullable
  @Override
  public StaticResourceXml getStaticResource() {
    return staticResource;
  }

  @Nullable
  @Override
  public String getIFrameResource() {
    return iFrameResource;
  }
}
