package io.maxads.ads.interstitial.vast3.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import io.maxads.ads.base.util.Util;

public class VASTCountdownTimerDrawable extends Drawable {
  private static final int CIRCLE_WIDTH_DP = 3;
  private static final float NUMBER_SIZE_SP = 18f;

  @NonNull private final Paint mUnfilledProgressPaint;
  @NonNull private final Paint mFilledProgressPaint;
  @NonNull private final Paint mCountdownNumberPaint;
  @NonNull private final Rect mTextRect;

  private int mSecondsRemaining;
  private float mSweepAngle;

  public VASTCountdownTimerDrawable(@NonNull Context context) {
    final int circleStrokeWidthPx = Util.dipsToIntPixels(CIRCLE_WIDTH_DP, context);
    final float numberSizePx = Util.dipsToPixels(NUMBER_SIZE_SP, context);

    mUnfilledProgressPaint = new Paint();
    mUnfilledProgressPaint.setColor(Color.WHITE);
    mUnfilledProgressPaint.setAlpha(128);
    mUnfilledProgressPaint.setStyle(Paint.Style.STROKE);
    mUnfilledProgressPaint.setStrokeWidth(circleStrokeWidthPx);
    mUnfilledProgressPaint.setAntiAlias(true);

    mFilledProgressPaint = new Paint();
    mFilledProgressPaint.setColor(Color.WHITE);
    mFilledProgressPaint.setAlpha(255);
    mFilledProgressPaint.setStyle(Paint.Style.STROKE);
    mFilledProgressPaint.setStrokeWidth(circleStrokeWidthPx);
    mFilledProgressPaint.setAntiAlias(true);

    mCountdownNumberPaint = new Paint();
    mCountdownNumberPaint.setColor(Color.WHITE);
    mCountdownNumberPaint.setTextAlign(Paint.Align.CENTER);
    mCountdownNumberPaint.setTextSize(numberSizePx);
    mCountdownNumberPaint.setAntiAlias(true);

    mTextRect = new Rect();
  }

  @Override
  public void draw(@NonNull Canvas canvas) {
    final int centerX = getBounds().centerX();
    final int centerY = getBounds().centerY();
    final int radius = Math.min(centerX, centerY);

    canvas.drawCircle(centerX, centerY, radius, mUnfilledProgressPaint);

    final String secondsRemainingText = String.valueOf(mSecondsRemaining);
    mCountdownNumberPaint.getTextBounds(secondsRemainingText, 0, secondsRemainingText.length(), mTextRect);
    final float textHeight = mCountdownNumberPaint.descent() - mCountdownNumberPaint.ascent();
    final float textOffset = (textHeight / 2) - mCountdownNumberPaint.descent();
    canvas.drawText(secondsRemainingText, getBounds().centerX(), getBounds().centerY() + textOffset,
      mCountdownNumberPaint);

    final RectF circle = new RectF(getBounds());
    canvas.drawArc(circle, -90, mSweepAngle, false, mFilledProgressPaint);
  }

  @Override
  public void setAlpha(int alpha) {
  }

  @Override
  public void setColorFilter(@Nullable ColorFilter colorFilter) {
  }

  @Override
  public int getOpacity() {
    return PixelFormat.UNKNOWN;
  }

  public void updateTimeRemaining(int totalTimeMs, int progressMs) {
    final int timeRemainingMs = totalTimeMs - progressMs;
    mSecondsRemaining = Math.round(timeRemainingMs / 1000f);
    mSweepAngle = 360f * progressMs / totalTimeMs;
    invalidateSelf();
  }
}
