package io.maxads.ads.interstitial.vast3.view;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import io.maxads.ads.base.Constants;
import io.maxads.ads.base.view.HtmlWebView;

public class VASTCompanionAdViewModuleImpl implements VASTCompanionAdViewModule, View.OnClickListener {
  @NonNull private final ViewGroup mCompanionAdContainer;
  @NonNull private final HtmlWebView mCompanionAd;
  @Nullable private Listener mListener;

  public VASTCompanionAdViewModuleImpl(@NonNull ViewGroup companionAdContainer, @NonNull HtmlWebView companionAd) {
    mCompanionAdContainer = companionAdContainer;
    mCompanionAdContainer.setOnClickListener(this);
    mCompanionAd = companionAd;
    mCompanionAd.setOnClickListener(this);
    mCompanionAd.setWebViewClient(new WebViewClient() {
      @Override
      public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (mListener != null) {
          mListener.onCompanionAdClicked(url);
        }
        return true;
      }
    });
  }

  @Override
  public void setListener(@Nullable Listener listener) {
    mListener = listener;
  }

  @Override
  public void loadCompanionAd(@Nullable String html, int widthPx, int heightPx) {
    if (html == null) {
      return;
    }

    mCompanionAd.loadDataWithBaseURL(Constants.MAXADS_URL, html, "text/html", "utf-8", null);
    mCompanionAd.getLayoutParams().width = widthPx;
    mCompanionAd.getLayoutParams().height = heightPx;
    mCompanionAd.requestLayout();
  }

  @Override
  public void showCompanionAd() {
    mCompanionAdContainer.setVisibility(View.VISIBLE);
  }

  @Override
  public void onClick(View v) {
    if (mListener == null) {
      return;
    }

    if (v == mCompanionAd || v == mCompanionAdContainer) {
      mListener.onCompanionAdClicked(null);
    }
  }
}
