package io.maxads.ads.interstitial.vast3.presenter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import io.maxads.ads.base.UrlHandlerDelegate;
import io.maxads.ads.interstitial.vast3.VASTApiClientDecorator;
import io.maxads.ads.interstitial.vast3.model.VASTIconConfig;
import io.maxads.ads.interstitial.vast3.model.VASTResource;
import io.maxads.ads.interstitial.vast3.view.VASTIconViewModule;

public class VASTIconPresenterImpl implements VASTIconPresenter, VASTIconViewModule.Listener {
  @NonNull private final VASTIconViewModule mVASTIconViewModule;
  @NonNull private final VASTIconConfig mVASTIconConfig;
  @NonNull private final VASTApiClientDecorator mVASTApiClientDecorator;

  public VASTIconPresenterImpl(@NonNull Context context,
                               @NonNull VASTIconViewModule vastIconViewModule,
                               @NonNull VASTIconConfig vastIconConfig,
                               @NonNull VASTApiClientDecorator vastApiClientDecorator) {
    this(vastIconViewModule, vastIconConfig, vastApiClientDecorator, new UrlHandlerDelegate(context));
  }

  public VASTIconPresenterImpl(@NonNull VASTIconViewModule VASTIconViewModule,
                               @NonNull VASTIconConfig VASTIconConfig,
                               @NonNull VASTApiClientDecorator VASTApiClientDecorator,
                               @NonNull UrlHandlerDelegate urlHandlerDelegate) {
    mVASTIconViewModule = VASTIconViewModule;
    mVASTIconViewModule.setListener(this);
    mVASTIconConfig = VASTIconConfig;
    mVASTApiClientDecorator = VASTApiClientDecorator;
    mUrlHandlerDelegate = urlHandlerDelegate;
  }

  @NonNull private final UrlHandlerDelegate mUrlHandlerDelegate;

  @Override
  public void loadIcon() {
    mVASTIconViewModule.loadIcon(mVASTIconConfig.getHtmlPayload(), mVASTIconConfig.getWidthPx(),
      mVASTIconConfig.getHeightPx());
  }

  @Override
  public void showIcon() {
    mVASTIconViewModule.showIcon();
    mVASTApiClientDecorator.fireVASTTrackers(mVASTIconConfig.getCreativeViewTrackers());
  }

  @Override
  public void hideIcon() {
    mVASTIconViewModule.hideIcon();
  }

  @Override
  public void onIconClicked(@Nullable String webViewClickThroughUrl) {
    mVASTApiClientDecorator.fireVASTTrackers(mVASTIconConfig.getClickTrackers());

    // Static image icons must use the clickthrough url from the VAST XML
    final VASTResource vastResource = mVASTIconConfig.getVASTResource();
    if (vastResource.getType().equals(VASTResource.Type.StaticResource)
      && vastResource.getCreativeType().equals(VASTResource.CreativeType.IMAGE)) {
      mUrlHandlerDelegate.handleUrl(mVASTIconConfig.getClickThroughUrl());

    } else if (webViewClickThroughUrl != null){
      // HTML and iFrame based icons are capable of providing their own click through urls
      mUrlHandlerDelegate.handleUrl(webViewClickThroughUrl);
    }
  }
}
