//
//  VastActivity.java
//

//  Copyright (c) 2014 Nexage. All rights reserved.
//

package io.maxads.ads.interstitial.vast3.activity;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.VideoView;

import io.maxads.ads.R;
import io.maxads.ads.base.MaxAds;
import io.maxads.ads.base.api.VASTApiClient;
import io.maxads.ads.base.util.MaxAdsLog;
import io.maxads.ads.base.view.HtmlWebView;
import io.maxads.ads.interstitial.InterstitialBroadcastSender;
import io.maxads.ads.interstitial.vast3.VASTApiClientDecorator;
import io.maxads.ads.interstitial.vast3.VASTError;
import io.maxads.ads.interstitial.vast3.VASTMacroData;
import io.maxads.ads.interstitial.vast3.model.VASTCompanionAdConfig;
import io.maxads.ads.interstitial.vast3.model.VASTIconConfig;
import io.maxads.ads.interstitial.vast3.model.VASTVideoConfig;
import io.maxads.ads.interstitial.vast3.presenter.EmptyVASTCompanionAdPresenter;
import io.maxads.ads.interstitial.vast3.presenter.EmptyVASTIconPresenter;
import io.maxads.ads.interstitial.vast3.presenter.VASTCompanionAdPresenter;
import io.maxads.ads.interstitial.vast3.presenter.VASTCompanionAdPresenterImpl;
import io.maxads.ads.interstitial.vast3.presenter.VASTIconPresenter;
import io.maxads.ads.interstitial.vast3.presenter.VASTIconPresenterImpl;
import io.maxads.ads.interstitial.vast3.presenter.VASTPresenter;
import io.maxads.ads.interstitial.vast3.view.VASTCompanionAdViewModule;
import io.maxads.ads.interstitial.vast3.view.VASTCompanionAdViewModuleImpl;
import io.maxads.ads.interstitial.vast3.view.VASTIconViewModule;
import io.maxads.ads.interstitial.vast3.view.VASTIconViewModuleImpl;
import io.maxads.ads.interstitial.vast3.view.VASTViewModule;
import io.maxads.ads.interstitial.vast3.view.VASTViewModuleImpl;

public class VASTActivity extends Activity implements VASTPresenter.Listener {

  @NonNull private static final String TAG = VASTActivity.class.getSimpleName();
  @NonNull public static final String VAST_VIDEO_CONFIG_KEY = "io.maxads.ads.interstitial.vast.model.VASTVideoConfig";
  @NonNull public static final String BROADCAST_ID_KEY = "broadcast_id_key";

  @Nullable private VASTPresenter mVASTPresenter;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    // hide title bar of application
    requestWindowFeature(Window.FEATURE_NO_TITLE);
    // hide status bar of Android
    getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

    setContentView(R.layout.activity_vast);

    // See if we are restoring the activity after being destroyed
    final VASTVideoConfig vastVideoConfig = savedInstanceState != null
      ? (VASTVideoConfig) savedInstanceState.getSerializable(VAST_VIDEO_CONFIG_KEY)

      // If not then use the original intent sent to initialize the activity
      : (VASTVideoConfig) getIntent().getSerializableExtra(VAST_VIDEO_CONFIG_KEY);

    if (vastVideoConfig == null) {
      MaxAdsLog.e(TAG, "Could not find valid VASTVideoConfig. Stopping VASTActivity.");
      finish();
      return;
    }

    final long broadcastId = getIntent().getLongExtra(BROADCAST_ID_KEY, -1);

    final VASTApiClient vastApiClient = MaxAds.getVASTApiClient();

    final VASTViewModule vastViewModule = new VASTViewModuleImpl(
      this,
      (VideoView) findViewById(R.id.video_view),
      (ImageView) findViewById(R.id.last_video_frame),
      (ImageView) findViewById(R.id.countdown_timer),
      (ImageView) findViewById(R.id.close_button));

    final VASTApiClientDecorator vastApiClientDecorator = new VASTApiClientDecorator(vastApiClient,
      new VASTMacroData() {
        @Nullable
        @Override
        public VASTError getVASTError() {
          return null;
        }

        @Nullable
        @Override
        public Integer getContentPlayhead() {
          return vastViewModule.videoGetCurrentPositionMs();
        }

        @Nullable
        @Override
        public String getAssetUri() {
          return vastVideoConfig.getMediaFileUrl();
        }
      });

    final VASTIconConfig vastIconConfig = vastVideoConfig.getVASTIconConfig();
    final VASTIconViewModule vastIconViewModule
      = new VASTIconViewModuleImpl((HtmlWebView) findViewById(R.id.icon));
    final VASTIconPresenter vastIconPresenter = vastIconConfig != null
      ? new VASTIconPresenterImpl(this, vastIconViewModule, vastIconConfig, vastApiClientDecorator)
      : new EmptyVASTIconPresenter();

    final VASTCompanionAdConfig vastCompanionAdConfig = vastVideoConfig.getVASTCompanionAdConfig();
    final VASTCompanionAdViewModule vastCompanionAdViewModule
      = new VASTCompanionAdViewModuleImpl((ViewGroup) findViewById(R.id.companion_ad_container),
      (HtmlWebView) findViewById(R.id.companion_ad));
    final VASTCompanionAdPresenter vastCompanionAdPresenter = vastCompanionAdConfig != null
      ? new VASTCompanionAdPresenterImpl(this, vastCompanionAdViewModule, vastCompanionAdConfig, vastApiClientDecorator)
      : new EmptyVASTCompanionAdPresenter();

    mVASTPresenter = new VASTPresenter(this, vastViewModule, vastIconPresenter, vastCompanionAdPresenter,
      vastApiClientDecorator, vastVideoConfig, new InterstitialBroadcastSender(this, broadcastId));
    mVASTPresenter.setListener(this);
  }

  @Override
  protected void onStart() {
    super.onStart();
    if (mVASTPresenter != null) {
      mVASTPresenter.prepare();
    }
  }

  @Override
  protected void onPause() {
    super.onPause();
    if (mVASTPresenter != null) {
      mVASTPresenter.stop();
    }
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
    if (mVASTPresenter != null) {
      mVASTPresenter.destroy();
    }
  }

  @Override
  protected void onSaveInstanceState(Bundle outState) {
    if (mVASTPresenter != null) {
      mVASTPresenter.onSaveInstanceState(outState);
    }
    super.onSaveInstanceState(outState);
  }

  @Override
  public void onBackPressed() {
    if (mVASTPresenter != null) {
      mVASTPresenter.onBackPressed();
    }
  }

  // VASTPresenter.Listener

  @Override
  public void onFinish() {
    finish();
  }
}
