package io.maxads.ads.interstitial.vast3;

import android.support.annotation.NonNull;

import io.maxads.ads.interstitial.InterstitialBroadcastReceiver;
import io.maxads.ads.interstitial.InterstitialBroadcastSender;
import io.maxads.ads.interstitial.vast3.model.VASTEventTracker;
import io.maxads.ads.interstitial.vast3.model.VASTVideoConfig;

public class VASTStartTimerListener implements VASTTimer.Listener {
  @NonNull private final VASTApiClientDecorator mVastApiClientDecorator;
  @NonNull private final VASTVideoConfig mVASTVideoConfig;
  @NonNull private final InterstitialBroadcastSender mInterstitialBroadcastSender;

  public VASTStartTimerListener(@NonNull VASTApiClientDecorator vastApiClientDecorator,
                                @NonNull VASTVideoConfig vastVideoConfig,
                                @NonNull InterstitialBroadcastSender interstitialBroadcastSender) {
    mVastApiClientDecorator = vastApiClientDecorator;
    mVASTVideoConfig = vastVideoConfig;
    mInterstitialBroadcastSender = interstitialBroadcastSender;
  }

  @Override
  public void onTick(int videoDurationMs, int currentPositionMs) {
    if (currentPositionMs > 0 && !mVASTVideoConfig.isVideoStarted()) {
      mVastApiClientDecorator.fireVASTTrackers(mVASTVideoConfig.getImpressionTrackers());
      mVastApiClientDecorator.fireVASTTrackers(mVASTVideoConfig.getEventTrackers(VASTEventTracker.Event.creativeView));
      mInterstitialBroadcastSender.sendBroadcast(InterstitialBroadcastReceiver.Action.IMPRESSED);
      mVASTVideoConfig.setVideoStarted(true);
    }
  }

  @Override
  public void onStopped(int videoDurationMs, boolean videoCompleted, boolean maxDurationExceeded) {
  }

  @Override
  public void onMaxDurationExceeded() {
  }
}
