package io.maxads.ads.interstitial.vast3;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

import java.util.List;

import io.maxads.ads.base.api.VASTApiClient;
import io.maxads.ads.interstitial.vast3.model.VASTTracker;
import io.maxads.ads.interstitial.vast3.xml_model.VASTXml;
import io.reactivex.Observable;
import okhttp3.ResponseBody;

public class VASTApiClientDecorator {
  @NonNull private final VASTApiClient mVASTApiClient;
  @NonNull private final VASTMacroData mDefaultVASTMacroData;

  public VASTApiClientDecorator(@NonNull VASTApiClient vastApiClient) {
    this(vastApiClient, VASTMacroData.EMPTY_VAST_MACRO_DATA);
  }

  public VASTApiClientDecorator(@NonNull VASTApiClient vastApiClient,
                                @NonNull VASTMacroData defaultVASTMacroData) {
    mVASTApiClient = vastApiClient;
    mDefaultVASTMacroData = defaultVASTMacroData;
  }

  @NonNull
  public Observable<VASTXml> getVASTXml(@NonNull String url) {
    return mVASTApiClient.getVastXml(url);
  }

  @NonNull
  public Observable<ResponseBody> getMediaFile(@NonNull String url) {
    return mVASTApiClient.getMediaFile(url);
  }

  public void fireVASTTracker(@NonNull VASTTracker vastTracker) {
    fireVASTTracker(vastTracker, VASTMacroData.EMPTY_VAST_MACRO_DATA);
  }

  public void fireVASTTracker(@NonNull VASTTracker vastTracker, @NonNull VASTMacroData vastMacroData) {
    mVASTApiClient.fireVASTTracker(vastTracker, composeMacroProcessor(vastMacroData));
  }

  public void fireVASTTrackers(@Nullable List<VASTTracker> vastTrackers) {
    fireVASTTrackers(vastTrackers, VASTMacroData.EMPTY_VAST_MACRO_DATA);
  }

  public void fireVASTTrackers(@Nullable List<VASTTracker> vastTrackers, @NonNull VASTMacroData vastMacroData) {
    mVASTApiClient.fireVASTTrackers(vastTrackers, composeMacroProcessor(vastMacroData));
  }

  @NonNull
  private VASTMacroProcessor composeMacroProcessor(@NonNull VASTMacroData vastMacroData) {
    return new VASTMacroProcessor()
      .withVASTError(vastMacroData.getVASTError() != null
        ? vastMacroData.getVASTError() : mDefaultVASTMacroData.getVASTError())

      .withContentPlayHeadMs(vastMacroData.getContentPlayhead() != null
        ? vastMacroData.getContentPlayhead() : mDefaultVASTMacroData.getContentPlayhead())

      .withAssetUri(vastMacroData.getAssetUri() != null
        ? vastMacroData.getAssetUri() : mDefaultVASTMacroData.getAssetUri());
  }
}
