package io.maxads.ads.interstitial.vast3;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import io.maxads.ads.interstitial.vast3.model.VASTIconConfig;
import io.maxads.ads.interstitial.vast3.xml_model.IconXml;

public class IconPicker {
  @NonNull private final Context mContext;

  public IconPicker(@NonNull Context context) {
    mContext = context;
  }

  @Nullable
  public VASTIconConfig pickIcon(@Nullable List<IconXml> iconXmls) {
    if (iconXmls == null) {
      return null;
    }

    final List<VASTIconConfig> filteredIcons = prefilterIcons(iconXmls);
    if (filteredIcons.isEmpty()) {
      return null;
    }

    final List<VASTIconConfig> htmlIcons = new ArrayList<>(filteredIcons.size());
    final List<VASTIconConfig> staticIcons = new ArrayList<>(filteredIcons.size());
    final List<VASTIconConfig> iFrameIcons = new ArrayList<>(filteredIcons.size());

    for (VASTIconConfig vastIconConfig : filteredIcons) {
      switch (vastIconConfig.getVASTResource().getType()) {
        case HTMLResource:
          htmlIcons.add(vastIconConfig);
          break;
        case StaticResource:
          staticIcons.add(vastIconConfig);
          break;
        case IFrameResource:
          iFrameIcons.add(vastIconConfig);
          break;
      }
    }

    if (!htmlIcons.isEmpty()) {
      return htmlIcons.get(0);
    } else if (!staticIcons.isEmpty()) {
      return staticIcons.get(0);
    } else {
      return iFrameIcons.get(0);
    }
  }

  private List<VASTIconConfig> prefilterIcons(@NonNull List<IconXml> iconXmls) {
    final List<VASTIconConfig> vastIconConfigs = new ArrayList<>(iconXmls.size());
    for (IconXml iconXml : iconXmls) {
      final VASTIconConfig vastIconConfig = VASTIconConfig.from(mContext, iconXml);
      if (vastIconConfig != null) {
        vastIconConfigs.add(vastIconConfig);
      }
    }

    return vastIconConfigs;
  }
}
